/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.algorithm.localsearch;

import es.usc.citius.hipster.algorithm.Algorithm;
import es.usc.citius.hipster.model.HeuristicNode;
import es.usc.citius.hipster.model.Node;
import es.usc.citius.hipster.model.function.NodeExpander;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;

public class AnnealingSearch<A, S, N extends HeuristicNode<A, S, Double, N>>
extends Algorithm<A, S, N> {
    private static final Double DEFAULT_ALPHA = 0.9;
    private static final Double DEFAULT_MIN_TEMP = 1.0E-5;
    private static final Double START_TEMP = 1.0;
    private N initialNode;
    private Double alpha;
    private Double minTemp;
    private AcceptanceProbability acceptanceProbability;
    private SuccessorFinder<A, S, N> successorFinder;
    private NodeExpander<A, S, N> nodeExpander;

    public AnnealingSearch(N initialNode, NodeExpander<A, S, N> nodeExpander, Double alpha, Double minTemp, AcceptanceProbability acceptanceProbability, SuccessorFinder<A, S, N> successorFinder) {
        if (initialNode == null) {
            throw new IllegalArgumentException("Provide a valid initial node");
        }
        this.initialNode = initialNode;
        if (nodeExpander == null) {
            throw new IllegalArgumentException("Provide a valid node expander");
        }
        this.nodeExpander = nodeExpander;
        if (alpha != null) {
            if (alpha <= 0.0 || alpha >= 1.0) {
                throw new IllegalArgumentException("alpha must be between 0. and 1.");
            }
            this.alpha = alpha;
        } else {
            this.alpha = DEFAULT_ALPHA;
        }
        if (minTemp != null) {
            if (minTemp < 0.0 || minTemp > 1.0) {
                throw new IllegalArgumentException("Minimum temperature must be between 0. and 1.");
            }
            this.minTemp = minTemp;
        } else {
            this.minTemp = DEFAULT_MIN_TEMP;
        }
        this.acceptanceProbability = acceptanceProbability != null ? acceptanceProbability : new AcceptanceProbability(){

            @Override
            public Double compute(Double oldScore, Double newScore, Double temp) {
                return newScore < oldScore ? 1.0 : Math.exp((oldScore - newScore) / temp);
            }
        };
        this.successorFinder = successorFinder != null ? successorFinder : new SuccessorFinder<A, S, N>(){

            @Override
            public N estimate(N node, NodeExpander<A, S, N> nodeExpander) {
                ArrayList<HeuristicNode> successors = new ArrayList<HeuristicNode>();
                for (HeuristicNode successor : nodeExpander.expand(node)) {
                    successors.add(successor);
                }
                Random randIndGen = new Random();
                return (HeuristicNode)successors.get(Math.abs(randIndGen.nextInt()) % successors.size());
            }
        };
    }

    public ASIterator iterator() {
        return new ASIterator();
    }

    static /* synthetic */ Double access$100() {
        return START_TEMP;
    }

    public static interface SuccessorFinder<A, S, N extends Node<A, S, N>> {
        public N estimate(N var1, NodeExpander<A, S, N> var2);
    }

    public static interface AcceptanceProbability {
        public Double compute(Double var1, Double var2, Double var3);
    }

    public class ASIterator
    implements Iterator<N> {
        private Queue<N> queue = new LinkedList();
        private Double bestScore = null;
        private Double curTemp = AnnealingSearch.access$100();

        private ASIterator() {
            this.bestScore = (Double)AnnealingSearch.this.initialNode.getEstimation();
            this.queue.add(AnnealingSearch.this.initialNode);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public N next() {
            HeuristicNode currentNode = (HeuristicNode)this.queue.poll();
            if (this.curTemp > AnnealingSearch.this.minTemp) {
                HeuristicNode newNode = null;
                for (int i = 0; i < 100; ++i) {
                    HeuristicNode randSuccessor = AnnealingSearch.this.successorFinder.estimate(currentNode, AnnealingSearch.this.nodeExpander);
                    Double score = (Double)randSuccessor.getScore();
                    if (!(AnnealingSearch.this.acceptanceProbability.compute(this.bestScore, score, this.curTemp) > Math.random())) continue;
                    newNode = randSuccessor;
                    this.bestScore = score;
                }
                if (newNode != null) {
                    this.queue.add(newNode);
                } else {
                    this.queue.add(currentNode);
                }
                this.curTemp = this.curTemp * AnnealingSearch.this.alpha;
            }
            return currentNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

