/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.algorithm.localsearch;

import es.usc.citius.hipster.algorithm.Algorithm;
import es.usc.citius.hipster.model.HeuristicNode;
import es.usc.citius.hipster.model.function.NodeExpander;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class HillClimbing<A, S, C extends Comparable<C>, N extends HeuristicNode<A, S, C, N>>
extends Algorithm<A, S, N> {
    private N initialNode;
    private NodeExpander<A, S, N> nodeExpander;
    private boolean enforced;

    public HillClimbing(N initialNode, NodeExpander<A, S, N> nodeExpander) {
        this(initialNode, nodeExpander, false);
    }

    public HillClimbing(N initialNode, NodeExpander<A, S, N> nodeExpander, boolean enforcedHillClimbing) {
        this.initialNode = initialNode;
        this.nodeExpander = nodeExpander;
        this.enforced = enforcedHillClimbing;
    }

    public EHCIterator iterator() {
        return new EHCIterator();
    }

    public class EHCIterator
    implements Iterator<N> {
        private Queue<N> queue = new LinkedList();
        private C bestScore = null;

        private EHCIterator() {
            this.bestScore = HillClimbing.this.initialNode.getEstimation();
            this.queue.add(HillClimbing.this.initialNode);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public N next() {
            HeuristicNode current = (HeuristicNode)this.queue.poll();
            HeuristicNode bestNode = null;
            for (HeuristicNode successor : HillClimbing.this.nodeExpander.expand(current)) {
                if (HillClimbing.this.enforced) {
                    Object score = successor.getScore();
                    if (score.compareTo(this.bestScore) < 0) {
                        this.bestScore = score;
                        this.queue.clear();
                        this.queue.add(successor);
                        break;
                    }
                } else {
                    if (bestNode == null) {
                        bestNode = successor;
                    }
                    if (successor.compareTo(bestNode) < 0) {
                        bestNode = successor;
                    }
                }
                if (!HillClimbing.this.enforced) continue;
                this.queue.add(successor);
            }
            if (!HillClimbing.this.enforced) {
                this.queue.add(bestNode);
            }
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Queue<N> getQueue() {
            return this.queue;
        }

        public void setQueue(Queue<N> queue) {
            this.queue = queue;
        }

        public C getBestScore() {
            return this.bestScore;
        }

        public void setBestScore(C bestScore) {
            this.bestScore = bestScore;
        }
    }
}

