/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.graph;

import es.usc.citius.hipster.graph.GraphEdge;
import es.usc.citius.hipster.graph.Pair;

public class DirectedEdge<V, E>
implements GraphEdge<V, E> {
    private Pair<V> vertices;
    private E value;

    public DirectedEdge(V vertex1, V vertex2, E value) {
        this.vertices = new Pair<V>(vertex1, vertex2);
        this.value = value;
    }

    @Override
    public V getVertex1() {
        return this.vertices.getE1();
    }

    @Override
    public V getVertex2() {
        return this.vertices.getE2();
    }

    @Override
    public E getEdgeValue() {
        return this.value;
    }

    @Override
    public GraphEdge.Type getType() {
        return GraphEdge.Type.DIRECTED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectedEdge that = (DirectedEdge)o;
        if (!this.vertices.equals(that.vertices)) {
            return false;
        }
        return !(this.value == null ? that.value != null : !this.value.equals(that.value));
    }

    public int hashCode() {
        int result = this.vertices.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

