/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.graph;

import es.usc.citius.hipster.graph.GraphBuilder;
import es.usc.citius.hipster.graph.HashBasedHipsterDirectedGraph;
import es.usc.citius.hipster.graph.HashBasedHipsterGraph;
import es.usc.citius.hipster.graph.HipsterDirectedGraph;
import es.usc.citius.hipster.graph.HipsterGraph;
import java.util.LinkedList;
import java.util.List;

public class GraphBuilder<V, E> {
    private List<Connection> connections = new LinkedList<Connection>();

    private GraphBuilder() {
    }

    public static <V, E> GraphBuilder<V, E> create() {
        return new GraphBuilder<V, E>();
    }

    public Vertex1 connect(V vertex) {
        return new Vertex1(vertex);
    }

    public GraphBuilder<V, E> connect(V vertex1, V vertex2) {
        Vertex1 vertex = new Vertex1(vertex1);
        vertex.to(vertex2);
        return this;
    }

    public HipsterDirectedGraph<V, E> createDirectedGraph() {
        HashBasedHipsterDirectedGraph<Object, Object> graph = HashBasedHipsterDirectedGraph.create();
        for (Connection c : this.connections) {
            graph.add(c.vertex1);
            graph.add(c.vertex2);
            graph.connect(c.vertex1, c.vertex2, c.edge);
        }
        return graph;
    }

    public HipsterGraph<V, E> createUndirectedGraph() {
        HashBasedHipsterGraph<Object, Object> graph = HashBasedHipsterGraph.create();
        for (Connection c : this.connections) {
            graph.add(c.vertex1);
            graph.add(c.vertex2);
            graph.connect(c.vertex1, c.vertex2, c.edge);
        }
        return graph;
    }

    @Deprecated
    public HipsterDirectedGraph buildDirectedGraph() {
        return this.createDirectedGraph();
    }

    @Deprecated
    public HipsterGraph buildUndirectedGraph() {
        return this.createUndirectedGraph();
    }

    public final class Vertex1 {
        V vertex1;

        private Vertex1(V vertex) {
            this.vertex1 = vertex;
        }

        public es.usc.citius.hipster.graph.GraphBuilder$Vertex1.Vertex2 to(V vertex) {
            return new Vertex2(vertex);
        }

        public class Vertex2 {
            V vertex2;

            private Vertex2(V vertex) {
                this.vertex2 = vertex;
                GraphBuilder.this.connections.add(new Connection(Vertex1.this.vertex1, this.vertex2));
            }

            public GraphBuilder<V, E> withEdge(E edge) {
                Connection connection = new Connection(Vertex1.this.vertex1, this.vertex2);
                int connectionIndex = GraphBuilder.this.connections.indexOf(connection);
                if (connectionIndex != -1) {
                    ((Connection)GraphBuilder.this.connections.get(connectionIndex)).setEdge(edge);
                } else {
                    connection.setEdge(edge);
                    GraphBuilder.this.connections.add(connection);
                }
                return GraphBuilder.this;
            }
        }
    }

    private class Connection {
        private V vertex1;
        private V vertex2;
        private E edge;

        private Connection(V vertex1, V vertex2, E edge) {
            this.vertex1 = vertex1;
            this.vertex2 = vertex2;
            this.edge = edge;
        }

        private Connection(V vertex1, V vertex2) {
            this.vertex1 = vertex1;
            this.vertex2 = vertex2;
            this.edge = new Object();
        }

        public V getVertex1() {
            return this.vertex1;
        }

        public void setVertex1(V vertex1) {
            this.vertex1 = vertex1;
        }

        public V getVertex2() {
            return this.vertex2;
        }

        public void setVertex2(V vertex2) {
            this.vertex2 = vertex2;
        }

        public E getEdge() {
            return this.edge;
        }

        public void setEdge(E edge) {
            this.edge = edge;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Connection that = (Connection)o;
            if (!this.vertex1.equals(that.vertex1)) {
                return false;
            }
            return this.vertex2.equals(that.vertex2);
        }
    }
}

