/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.graph;

import es.usc.citius.hipster.graph.GraphEdge;
import es.usc.citius.hipster.graph.HipsterDirectedGraph;
import es.usc.citius.hipster.graph.HipsterGraph;
import es.usc.citius.hipster.model.Transition;
import es.usc.citius.hipster.model.function.CostFunction;
import es.usc.citius.hipster.model.function.HeuristicFunction;
import es.usc.citius.hipster.model.function.TransitionFunction;
import es.usc.citius.hipster.model.function.impl.BinaryOperation;
import es.usc.citius.hipster.model.function.impl.ScalarOperation;
import es.usc.citius.hipster.model.impl.UnweightedNode;
import es.usc.citius.hipster.model.impl.WeightedNode;
import es.usc.citius.hipster.model.problem.ProblemBuilder;
import es.usc.citius.hipster.model.problem.SearchComponents;
import es.usc.citius.hipster.model.problem.SearchProblem;
import es.usc.citius.hipster.util.Function;
import java.util.ArrayList;

public final class GraphSearchProblem {
    public static <V> FromVertex<V> startingFrom(V vertex) {
        return new FromVertex(vertex);
    }

    public static class FromVertex<V> {
        private V fromVertex;
        private V toVertex;

        public FromVertex<V> goalAt(V vertex) {
            this.toVertex = vertex;
            return this;
        }

        private FromVertex(V fromVertex) {
            this.fromVertex = fromVertex;
        }

        public <E> CostType<E> in(final HipsterGraph<V, E> graph) {
            TransitionFunction tf;
            if (graph instanceof HipsterDirectedGraph) {
                final HipsterDirectedGraph dg = (HipsterDirectedGraph)graph;
                tf = new TransitionFunction<E, V>(){

                    @Override
                    public Iterable<Transition<E, V>> transitionsFrom(V state) {
                        ArrayList transitions = new ArrayList();
                        for (GraphEdge edge : dg.outgoingEdgesOf(state)) {
                            transitions.add(Transition.create(state, edge.getEdgeValue(), edge.getVertex2()));
                        }
                        return transitions;
                    }
                };
            } else {
                tf = new TransitionFunction<E, V>(){

                    @Override
                    public Iterable<Transition<E, V>> transitionsFrom(V state) {
                        ArrayList transitions = new ArrayList();
                        for (GraphEdge edge : graph.edgesOf(state)) {
                            Object oppositeVertex = edge.getVertex1().equals(state) ? edge.getVertex2() : edge.getVertex1();
                            transitions.add(Transition.create(state, edge.getEdgeValue(), oppositeVertex));
                        }
                        return transitions;
                    }
                };
            }
            return new CostType(tf);
        }

        public class CostType<E> {
            private TransitionFunction<E, V> tf;

            private CostType(TransitionFunction<E, V> tf) {
                this.tf = tf;
            }

            public HeuristicType<Double> takeCostsFromEdges() {
                CostFunction cf = new CostFunction<E, V, Double>(){

                    @Override
                    public Double evaluate(Transition<E, V> transition) {
                        Object action = transition.getAction();
                        if (action instanceof Number) {
                            return ((Number)action).doubleValue();
                        }
                        if (action instanceof String) {
                            try {
                                return Double.parseDouble((String)action);
                            }
                            catch (NumberFormatException e) {
                                throw new IllegalArgumentException("Exception ocurred when tryingto cast " + action + " to a number. Use the method " + "extractCostsFromEdges to define a custom evaluation strategy.", e);
                            }
                        }
                        return 1.0;
                    }
                };
                return new HeuristicType<Double>(cf, BinaryOperation.doubleAdditionOp()).useScaleAlgebra(ScalarOperation.doubleMultiplicationOp());
            }

            public HeuristicType<Double> extractCostFromEdges(final Function<E, Double> extractor) {
                CostFunction cf = new CostFunction<E, V, Double>(){

                    @Override
                    public Double evaluate(Transition<E, V> transition) {
                        return (Double)extractor.apply(transition.getAction());
                    }
                };
                return new HeuristicType<Double>(cf, BinaryOperation.doubleAdditionOp()).useScaleAlgebra(ScalarOperation.doubleMultiplicationOp());
            }

            public <C extends Comparable<C>> HeuristicType<C> useGenericCosts(BinaryOperation<C> costAlgebra) {
                CostFunction cf = new CostFunction<E, V, C>(){

                    @Override
                    public C evaluate(Transition<E, V> transition) {
                        return (Comparable)transition.getAction();
                    }
                };
                return new HeuristicType(cf, costAlgebra);
            }

            public SearchProblem<E, V, UnweightedNode<E, V>> build() {
                return ProblemBuilder.create().initialState(FromVertex.this.fromVertex, FromVertex.this.toVertex).defineProblemWithExplicitActions().useTransitionFunction(this.tf).build();
            }

            public class HeuristicType<C extends Comparable<C>> {
                private CostFunction<E, V, C> cf;
                private BinaryOperation<C> costAlgebra;
                private ScalarOperation<C> scaleAlgebra;

                private HeuristicType(CostFunction<E, V, C> cf, BinaryOperation<C> costAlgebra) {
                    this.cf = cf;
                    this.costAlgebra = costAlgebra;
                }

                public HeuristicType<C> useScaleAlgebra(ScalarOperation<C> scaleAlgebra) {
                    this.scaleAlgebra = scaleAlgebra;
                    return this;
                }

                public Final useHeuristicFunction(HeuristicFunction<V, C> hf) {
                    return new Final(hf);
                }

                public SearchProblem<E, V, WeightedNode<E, V, C>> build() {
                    return ProblemBuilder.create().initialState(FromVertex.this.fromVertex).defineProblemWithExplicitActions().useTransitionFunction(CostType.this.tf).useGenericCostFunction(this.cf, this.costAlgebra).build();
                }

                public class Final {
                    private HeuristicFunction<V, C> hf;

                    private Final(HeuristicFunction<V, C> hf) {
                        this.hf = hf;
                    }

                    public SearchComponents<E, V, C> components() {
                        return new SearchComponents(FromVertex.this.fromVertex, FromVertex.this.toVertex, HeuristicType.this.cf, this.hf, CostType.this.tf, CostType.this.tf, HeuristicType.this.costAlgebra, HeuristicType.this.scaleAlgebra);
                    }

                    public SearchProblem<E, V, WeightedNode<E, V, C>> build() {
                        return ProblemBuilder.create().initialState(FromVertex.this.fromVertex).defineProblemWithExplicitActions().useTransitionFunction(CostType.this.tf).useGenericCostFunction(HeuristicType.this.cf, HeuristicType.this.costAlgebra).useHeuristicFunction(this.hf).build();
                    }
                }
            }
        }
    }
}

