/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.graph;

import es.usc.citius.hipster.graph.GraphEdge;
import es.usc.citius.hipster.graph.HipsterMutableGraph;
import es.usc.citius.hipster.graph.UndirectedEdge;
import es.usc.citius.hipster.util.F;
import es.usc.citius.hipster.util.Function;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class HashBasedHipsterGraph<V, E>
implements HipsterMutableGraph<V, E> {
    protected HashMap<V, Set<GraphEdge<V, E>>> connected = new HashMap();

    @Override
    public boolean add(V v) {
        if (!this.connected.containsKey(v)) {
            this.connected.put(v, new LinkedHashSet());
            return true;
        }
        return false;
    }

    @Override
    public Set<V> add(V ... vertices) {
        HashSet<V> added = new HashSet<V>();
        for (V v : vertices) {
            if (!this.add(v)) continue;
            added.add(v);
        }
        return added;
    }

    @Override
    public boolean remove(V v) {
        Set<GraphEdge<V, E>> edges = this.connected.get(v);
        if (edges == null) {
            return false;
        }
        Iterator<GraphEdge<V, E>> it = edges.iterator();
        while (it.hasNext()) {
            GraphEdge<V, E> edge = it.next();
            it.remove();
            V v2 = edge.getVertex1().equals(v) ? edge.getVertex2() : edge.getVertex1();
            Iterator<GraphEdge<V, E>> it2 = this.connected.get(v2).iterator();
            while (it2.hasNext()) {
                GraphEdge<V, E> edge2 = it2.next();
                if (!edge2.getVertex1().equals(v) && !edge2.getVertex2().equals(v)) continue;
                it2.remove();
            }
        }
        this.connected.remove(v);
        return true;
    }

    @Override
    public Set<V> remove(V ... vertices) {
        HashSet<V> removed = new HashSet<V>();
        for (V v : vertices) {
            if (!this.remove(v)) continue;
            removed.add(v);
        }
        return removed;
    }

    @Override
    public GraphEdge<V, E> connect(V v1, V v2, E value) {
        if (v1 == null || v2 == null) {
            throw new IllegalArgumentException("Invalid vertices. A vertex cannot be null");
        }
        if (!this.connected.containsKey(v1)) {
            throw new IllegalArgumentException(v1 + " is not a vertex of the graph");
        }
        if (!this.connected.containsKey(v2)) {
            throw new IllegalArgumentException(v2 + " is not a vertex of the graph");
        }
        GraphEdge<V, E> edge = this.buildEdge(v1, v2, value);
        this.connected.get(v1).add(edge);
        this.connected.get(v2).add(edge);
        return edge;
    }

    public GraphEdge<V, E> buildEdge(V v1, V v2, E value) {
        return new UndirectedEdge<V, E>(v1, v2, value);
    }

    private Map.Entry<V, GraphEdge<V, E>> createEntry(final V vertex, final GraphEdge<V, E> edge) {
        return new Map.Entry<V, GraphEdge<V, E>>(){

            @Override
            public V getKey() {
                return vertex;
            }

            @Override
            public GraphEdge<V, E> getValue() {
                return edge;
            }

            @Override
            public GraphEdge<V, E> setValue(GraphEdge<V, E> value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected Iterable<Map.Entry<V, GraphEdge<V, E>>> vedges() {
        return F.flatMap(this.connected.entrySet(), new Function<Map.Entry<V, Set<GraphEdge<V, E>>>, Iterable<Map.Entry<V, GraphEdge<V, E>>>>(){

            @Override
            public Iterable<Map.Entry<V, GraphEdge<V, E>>> apply(final Map.Entry<V, Set<GraphEdge<V, E>>> entry) {
                return F.map(entry.getValue(), new Function<GraphEdge<V, E>, Map.Entry<V, GraphEdge<V, E>>>(){

                    @Override
                    public Map.Entry<V, GraphEdge<V, E>> apply(GraphEdge<V, E> input) {
                        return HashBasedHipsterGraph.this.createEntry(entry.getKey(), input);
                    }
                });
            }
        });
    }

    @Override
    public Iterable<GraphEdge<V, E>> edges() {
        return F.map(this.vedges(), new Function<Map.Entry<V, GraphEdge<V, E>>, GraphEdge<V, E>>(){

            @Override
            public GraphEdge<V, E> apply(Map.Entry<V, GraphEdge<V, E>> entry) {
                return entry.getValue();
            }
        });
    }

    @Override
    public Iterable<V> vertices() {
        return this.connected.keySet();
    }

    @Override
    public Iterable<GraphEdge<V, E>> edgesOf(V vertex) {
        Set<GraphEdge<V, E>> set = this.connected.get(vertex);
        if (set == null) {
            set = Collections.emptySet();
        }
        return set;
    }

    public HashMap<V, Set<GraphEdge<V, E>>> getConnected() {
        return this.connected;
    }

    public void setConnected(HashMap<V, Set<GraphEdge<V, E>>> connected) {
        this.connected = connected;
    }

    public static <V, E> HashBasedHipsterGraph<V, E> create() {
        return new HashBasedHipsterGraph<V, E>();
    }
}

