/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.graph;

import java.util.concurrent.atomic.AtomicInteger;

public class UniqueEdge<V> {
    private V value;
    private final String edgeId;
    private static final AtomicInteger idGenerator = new AtomicInteger(0);

    public UniqueEdge(V value) {
        this.value = value;
        this.edgeId = String.valueOf(idGenerator.getAndIncrement());
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public String getEdgeId() {
        return this.edgeId;
    }

    public static <V> UniqueEdge<V> create(V value) {
        return new UniqueEdge<V>(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniqueEdge that = (UniqueEdge)o;
        if (!this.edgeId.equals(that.edgeId)) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.edgeId.hashCode();
        return result;
    }

    public String toString() {
        return "UniqueEdge{value=" + this.value + ", edgeId='" + this.edgeId + '\'' + '}';
    }
}

