/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.model;

import es.usc.citius.hipster.model.Node;
import java.util.LinkedList;
import java.util.List;

public class AbstractNode<A, S, N extends AbstractNode<A, S, N>>
implements Node<A, S, N> {
    protected N previousNode;
    protected S state;
    protected A action;
    protected int pathSize;

    public AbstractNode(N previousNode, S state, A action) {
        this.previousNode = previousNode;
        this.state = state;
        this.action = action;
        this.pathSize = previousNode != null ? ((AbstractNode)previousNode).pathSize + 1 : 1;
    }

    @Override
    public List<N> path() {
        LinkedList<AbstractNode> path = new LinkedList<AbstractNode>();
        AbstractNode<A, S, N> currentNode = this;
        while (currentNode != null) {
            path.addFirst(currentNode);
            currentNode = currentNode.previousNode;
        }
        return path;
    }

    @Override
    public int pathSize() {
        return this.pathSize;
    }

    @Override
    public N previousNode() {
        return this.previousNode;
    }

    @Override
    public S state() {
        return this.state;
    }

    @Override
    public A action() {
        return this.action;
    }

    public String toString() {
        return "Node{action=" + this.action + ", state=" + this.state() + '}';
    }
}

