/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.model.function.impl;

import es.usc.citius.hipster.model.ADStarNode;
import es.usc.citius.hipster.model.Transition;
import es.usc.citius.hipster.model.function.CostFunction;
import es.usc.citius.hipster.model.function.HeuristicFunction;
import es.usc.citius.hipster.model.function.NodeExpander;
import es.usc.citius.hipster.model.function.NodeFactory;
import es.usc.citius.hipster.model.function.ScalarFunction;
import es.usc.citius.hipster.model.function.TransitionFunction;
import es.usc.citius.hipster.model.function.impl.BinaryOperation;
import es.usc.citius.hipster.model.problem.SearchComponents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ADStarNodeExpander<A, S, C extends Comparable<C>, N extends ADStarNode<A, S, C, N>>
implements NodeExpander<A, S, N> {
    private final TransitionFunction<A, S> successorFunction;
    private final TransitionFunction<A, S> predecessorFunction;
    private final CostFunction<A, S, C> costFunction;
    private final HeuristicFunction<S, C> heuristicFunction;
    private final BinaryOperation<C> add;
    private final ScalarFunction<C> scale;
    private final NodeFactory<A, S, N> nodeFactory;
    private Map<S, N> visited;
    private double epsilon;

    public ADStarNodeExpander(SearchComponents<A, S, C> components, NodeFactory<A, S, N> factory, double epsilon) {
        this(components.successorFunction(), components.predecessorFunction(), components.costFunction(), components.heuristicFunction(), components.costAlgebra(), components.scaleAlgebra(), factory, epsilon);
    }

    public ADStarNodeExpander(TransitionFunction<A, S> successorFunction, TransitionFunction<A, S> predecessorFunction, CostFunction<A, S, C> costFunction, HeuristicFunction<S, C> heuristicFunction, BinaryOperation<C> add, ScalarFunction<C> scale, NodeFactory<A, S, N> nodeFactory, double epsilon) {
        this.successorFunction = successorFunction;
        this.predecessorFunction = predecessorFunction;
        this.costFunction = costFunction;
        this.heuristicFunction = heuristicFunction;
        this.add = add;
        this.scale = scale;
        this.nodeFactory = nodeFactory;
        this.visited = new HashMap<S, N>();
        this.epsilon = epsilon;
    }

    @Override
    public Iterable<N> expand(N node) {
        ArrayList<ADStarNode> nodes = new ArrayList<ADStarNode>();
        boolean consistency = node.isConsistent();
        for (Transition<A, S> transition : this.successorFunction.transitionsFrom(node.state())) {
            ADStarNode successorNode = (ADStarNode)this.visited.get(transition.getState());
            if (successorNode == null) {
                successorNode = (ADStarNode)this.nodeFactory.makeNode(node, transition);
                this.visited.put(transition.getState(), successorNode);
            }
            if (consistency) {
                successorNode.setDoUpdate(this.updateConsistent(successorNode, node, transition));
            } else if (transition.getState().equals(node.state())) {
                this.updateInconsistent(successorNode, this.predecessorsMap(transition.getState()));
                successorNode.setDoUpdate(true);
            }
            nodes.add(successorNode);
        }
        return nodes;
    }

    public Iterable<N> expandTransitionsChanged(S begin, N current, Iterable<Transition<A, S>> transitions) {
        ArrayList<ADStarNode> nodes = new ArrayList<ADStarNode>();
        for (Transition<A, S> transition : transitions) {
            S state = transition.getState();
            if (state.equals(begin)) continue;
            ADStarNode node = (ADStarNode)this.visited.get(state);
            if (node == null) {
                node = (ADStarNode)this.nodeFactory.makeNode(current, transition);
                this.visited.put(state, node);
            }
            this.updateInconsistent(node, this.predecessorsMap(transition.getState()));
            nodes.add(node);
        }
        return nodes;
    }

    private boolean updateConsistent(N node, N parent, Transition<A, S> transition) {
        C accumulatedCost = this.add.apply((C)parent.getG(), this.costFunction.evaluate(transition));
        if (node.getG().compareTo(accumulatedCost) > 0) {
            node.setPreviousNode(parent);
            node.setG(accumulatedCost);
            node.setState(transition.getState());
            node.setAction(transition.getAction());
            node.setKey(new ADStarNode.Key<Comparable>((Comparable)node.getG(), (Comparable)node.getV(), (Comparable)this.heuristicFunction.estimate(transition.getState()), this.epsilon, (BinaryOperation<Comparable>)this.add, (ScalarFunction<Comparable>)this.scale));
            return true;
        }
        return false;
    }

    private boolean updateInconsistent(N node, Map<Transition<A, S>, N> predecessorMap) {
        C minValue = this.add.getIdentityElem();
        ADStarNode minParent = null;
        Transition<A, S> minTransition = null;
        for (Map.Entry<Transition<A, S>, N> current : predecessorMap.entrySet()) {
            C value = this.add.apply((C)((ADStarNode)current.getValue()).getV(), this.costFunction.evaluate(current.getKey()));
            if (value.compareTo(minValue) >= 0) continue;
            minValue = value;
            minParent = (ADStarNode)current.getValue();
            minTransition = current.getKey();
        }
        node.setPreviousNode(minParent);
        node.setG(minValue);
        node.setState(minTransition.getState());
        node.setAction(minTransition.getAction());
        node.setKey(new ADStarNode.Key<Comparable>((Comparable)node.getG(), (Comparable)node.getV(), (Comparable)this.heuristicFunction.estimate(minTransition.getState()), this.epsilon, (BinaryOperation<Comparable>)this.add, (ScalarFunction<Comparable>)this.scale));
        return true;
    }

    private Map<Transition<A, S>, N> predecessorsMap(S current) {
        HashMap<Transition<A, S>, ADStarNode> mapPredecessors = new HashMap<Transition<A, S>, ADStarNode>();
        for (Transition<A, S> predecessor : this.predecessorFunction.transitionsFrom(current)) {
            ADStarNode predecessorNode = (ADStarNode)this.visited.get(predecessor.getState());
            if (predecessorNode == null) continue;
            mapPredecessors.put(predecessor, predecessorNode);
        }
        return mapPredecessors;
    }

    public void setMaxV(N node) {
        node.setV(this.add.getMaxElem());
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public Map<S, N> getVisited() {
        return this.visited;
    }

    public void clearVisited() {
        this.visited = new HashMap<S, N>();
    }

    public N makeNode(N from, Transition<A, S> transition) {
        return (N)((ADStarNode)this.nodeFactory.makeNode(from, transition));
    }
}

