/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.model.function.impl;

import es.usc.citius.hipster.model.function.BinaryFunction;

public class BinaryOperation<E extends Comparable<E>>
implements BinaryFunction<E> {
    private E maxElem;
    private E identityElem;
    private BinaryFunction<E> op;

    public BinaryOperation(BinaryFunction<E> operation, E identityElem, E maxElem) {
        assert (((Comparable)operation.apply(identityElem, maxElem)).compareTo(maxElem) == 0);
        assert (((Comparable)operation.apply(maxElem, identityElem)).compareTo(maxElem) == 0);
        assert (((Comparable)operation.apply(identityElem, identityElem)).compareTo(identityElem) == 0);
        this.maxElem = maxElem;
        this.identityElem = identityElem;
        this.op = operation;
    }

    @Override
    public E apply(E a, E b) {
        return (E)((Comparable)this.op.apply(a, b));
    }

    public E getMaxElem() {
        return this.maxElem;
    }

    public E getIdentityElem() {
        return this.identityElem;
    }

    public static BinaryOperation<Double> doubleAdditionOp() {
        return new BinaryOperation<Double>(new BinaryFunction<Double>(){

            @Override
            public Double apply(Double a, Double b) {
                return a + b;
            }
        }, 0.0, Double.POSITIVE_INFINITY);
    }

    public static BinaryOperation<Double> doubleMultiplicationOp() {
        return new BinaryOperation<Double>(new BinaryFunction<Double>(){

            @Override
            public Double apply(Double a, Double b) {
                return a * b;
            }
        }, 1.0, Double.POSITIVE_INFINITY);
    }
}

