/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.model.function.impl;

import es.usc.citius.hipster.model.Transition;
import es.usc.citius.hipster.model.function.CostFunction;
import es.usc.citius.hipster.model.function.HeuristicFunction;
import es.usc.citius.hipster.model.function.NodeFactory;
import es.usc.citius.hipster.model.function.impl.BinaryOperation;
import es.usc.citius.hipster.model.impl.WeightedNode;

public class WeightedNodeFactory<A, S, C extends Comparable<C>>
implements NodeFactory<A, S, WeightedNode<A, S, C>> {
    private CostFunction<A, S, C> gf;
    private HeuristicFunction<S, C> hf;
    private BinaryOperation<C> costAccumulator;

    public WeightedNodeFactory(CostFunction<A, S, C> costFunction, HeuristicFunction<S, C> heuristicFunction, BinaryOperation<C> costAccumulator) {
        this.gf = costFunction;
        this.hf = heuristicFunction;
        this.costAccumulator = costAccumulator;
    }

    public WeightedNodeFactory(CostFunction<A, S, C> costFunction, BinaryOperation<C> costAccumulator) {
        this.gf = costFunction;
        this.hf = new HeuristicFunction<S, C>(){

            @Override
            public C estimate(S state) {
                return WeightedNodeFactory.this.costAccumulator.getIdentityElem();
            }
        };
        this.costAccumulator = costAccumulator;
    }

    @Override
    public WeightedNode<A, S, C> makeNode(WeightedNode<A, S, C> fromNode, Transition<A, S> transition) {
        C cost = fromNode == null ? this.costAccumulator.getIdentityElem() : this.costAccumulator.apply(fromNode.getCost(), this.gf.evaluate(transition));
        Comparable estimatedDistance = (Comparable)this.hf.estimate(transition.getState());
        Comparable score = this.costAccumulator.apply(cost, (C)estimatedDistance);
        return new WeightedNode<A, S, Comparable>(fromNode, transition.getState(), transition.getAction(), (Comparable)cost, estimatedDistance, score);
    }
}

