/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.util;

import es.usc.citius.hipster.util.Function;
import es.usc.citius.hipster.util.Iterators;
import java.util.Iterator;

public final class F {
    private F() {
    }

    public static <T, E> Iterable<E> map(final Iterable<T> it, final Function<? super T, ? extends E> mapf) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return F.map(it.iterator(), mapf);
            }
        };
    }

    public static <T, E> Iterator<E> map(final Iterator<T> it, final Function<? super T, ? extends E> mapf) {
        return new Iterators.AbstractIterator<E>(){

            @Override
            protected E computeNext() {
                if (it.hasNext()) {
                    return mapf.apply(it.next());
                }
                return null;
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<T> it, final Function<? super T, Boolean> condition) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return F.filter(it.iterator(), condition);
            }
        };
    }

    public static <T> Iterator<T> filter(final Iterator<T> it, final Function<? super T, Boolean> condition) {
        return new Iterators.AbstractIterator<T>(){

            @Override
            protected T computeNext() {
                while (it.hasNext()) {
                    Object next = it.next();
                    if (!((Boolean)condition.apply(next)).booleanValue()) continue;
                    return next;
                }
                return null;
            }
        };
    }

    public static <E, T> Iterable<T> flatMap(final Iterable<E> it, final Function<? super E, ? extends Iterable<? extends T>> mapf) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return F.flatMap(it.iterator(), new Function<E, Iterator<? extends T>>(){

                    @Override
                    public Iterator<? extends T> apply(E input) {
                        return ((Iterable)mapf.apply(input)).iterator();
                    }
                });
            }
        };
    }

    public static <E, T> Iterator<T> flatMap(final Iterator<E> it, final Function<? super E, ? extends Iterator<? extends T>> mapf) {
        return new Iterators.AbstractIterator<T>(){
            Iterator<Iterator<? extends T>> mapIt;
            Iterator<? extends T> current;
            {
                this.mapIt = F.map(it, mapf);
                this.current = this.mapIt.hasNext() ? this.mapIt.next() : Iterators.empty();
            }

            @Override
            protected T computeNext() {
                if (this.current.hasNext()) {
                    return this.current.next();
                }
                if (this.mapIt.hasNext()) {
                    this.current = this.mapIt.next();
                    return this.computeNext();
                }
                return null;
            }
        };
    }
}

