/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Iterators {
    public static <E> Iterator<E> empty() {
        return new AbstractIterator<E>(){

            @Override
            protected E computeNext() {
                return null;
            }
        };
    }

    public static abstract class AbstractIterator<E>
    implements Iterator<E> {
        protected E current;

        protected AbstractIterator() {
        }

        protected abstract E computeNext();

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                this.current = this.computeNext();
            }
            return this.current != null;
        }

        @Override
        public E next() {
            if (this.current != null) {
                E next = this.current;
                this.current = null;
                return next;
            }
            E next = this.computeNext();
            if (next == null) {
                throw new NoSuchElementException("next");
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

