/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.util.examples;

import es.usc.citius.hipster.graph.GraphBuilder;
import es.usc.citius.hipster.graph.HipsterGraph;
import es.usc.citius.hipster.model.function.HeuristicFunction;
import java.util.HashMap;
import java.util.Map;

public class RomanianProblem {
    private static final Map<City, Double> heuristicMap = new HashMap<City, Double>();
    private static final HipsterGraph<City, Double> graph;

    public static HipsterGraph<City, Double> graph() {
        return graph;
    }

    public static Map<City, Double> heuristics() {
        return heuristicMap;
    }

    public static HeuristicFunction<City, Double> heuristicFunction() {
        return new HeuristicFunction<City, Double>(){

            @Override
            public Double estimate(City state) {
                return RomanianProblem.heuristics().get((Object)state);
            }
        };
    }

    static {
        heuristicMap.put(City.Oradea, 380.0);
        heuristicMap.put(City.Zerind, 374.0);
        heuristicMap.put(City.Arad, 366.0);
        heuristicMap.put(City.Timisoara, 329.0);
        heuristicMap.put(City.Lugoj, 244.0);
        heuristicMap.put(City.Mehadia, 241.0);
        heuristicMap.put(City.Drobeta, 242.0);
        heuristicMap.put(City.Craiova, 160.0);
        heuristicMap.put(City.Rimnicu_Vilcea, 193.0);
        heuristicMap.put(City.Pitesti, 100.0);
        heuristicMap.put(City.Sibiu, 253.0);
        heuristicMap.put(City.Fagaras, 176.0);
        heuristicMap.put(City.Giurgiu, 77.0);
        heuristicMap.put(City.Urziceni, 80.0);
        heuristicMap.put(City.Hirsova, 151.0);
        heuristicMap.put(City.Eforie, 161.0);
        heuristicMap.put(City.Vaslui, 199.0);
        heuristicMap.put(City.Iasi, 226.0);
        heuristicMap.put(City.Neamt, 234.0);
        heuristicMap.put(City.Bucharest, 0.0);
        graph = GraphBuilder.create().connect(City.Arad).to((Object)City.Zerind).withEdge(75.0).connect(City.Arad).to((Object)City.Timisoara).withEdge(118.0).connect(City.Arad).to((Object)City.Sibiu).withEdge(140.0).connect(City.Bucharest).to((Object)City.Giurgiu).withEdge(90.0).connect(City.Bucharest).to((Object)City.Urziceni).withEdge(85.0).connect(City.Bucharest).to((Object)City.Fagaras).withEdge(211.0).connect(City.Bucharest).to((Object)City.Pitesti).withEdge(101.0).connect(City.Craiova).to((Object)City.Drobeta).withEdge(120.0).connect(City.Craiova).to((Object)City.Rimnicu_Vilcea).withEdge(146.0).connect(City.Craiova).to((Object)City.Pitesti).withEdge(138.0).connect(City.Drobeta).to((Object)City.Mehadia).withEdge(75.0).connect(City.Eforie).to((Object)City.Hirsova).withEdge(86.0).connect(City.Fagaras).to((Object)City.Sibiu).withEdge(99.0).connect(City.Hirsova).to((Object)City.Urziceni).withEdge(98.0).connect(City.Iasi).to((Object)City.Neamt).withEdge(87.0).connect(City.Iasi).to((Object)City.Vaslui).withEdge(92.0).connect(City.Lugoj).to((Object)City.Timisoara).withEdge(111.0).connect(City.Lugoj).to((Object)City.Mehadia).withEdge(70.0).connect(City.Oradea).to((Object)City.Zerind).withEdge(71.0).connect(City.Oradea).to((Object)City.Sibiu).withEdge(151.0).connect(City.Pitesti).to((Object)City.Rimnicu_Vilcea).withEdge(97.0).connect(City.Rimnicu_Vilcea).to((Object)City.Sibiu).withEdge(80.0).connect(City.Urziceni).to((Object)City.Vaslui).withEdge(142.0).createUndirectedGraph();
    }

    public static enum City {
        Arad,
        Bucharest,
        Craiova,
        Drobeta,
        Eforie,
        Fagaras,
        Giurgiu,
        Hirsova,
        Iasi,
        Lugoj,
        Mehadia,
        Neamt,
        Oradea,
        Pitesti,
        Rimnicu_Vilcea,
        Sibiu,
        Timisoara,
        Urziceni,
        Vaslui,
        Zerind;

    }
}

