/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.util.examples.maze;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Maze2D {
    private char[][] maze;
    private Point initialLoc;
    private Point goalLoc;
    private int rows;
    private int columns;
    private static Set<Character> FREE_TILES = new HashSet<Character>(Arrays.asList(Character.valueOf(' '), Character.valueOf('S'), Character.valueOf('G'), Character.valueOf('.')));

    public Maze2D(char[][] maze) {
        this.maze = maze;
        this.rows = maze.length;
        this.columns = this.findMaxRowLength(maze);
        this.initialLoc = this.charToPoint(Symbol.START.value());
        this.goalLoc = this.charToPoint(Symbol.GOAL.value());
    }

    private Point charToPoint(char c) {
        for (int row = 0; row < this.rows; ++row) {
            int column = 0;
            while (row < this.columns) {
                if (this.maze[row][column] == c) {
                    return new Point(column, row);
                }
                ++column;
            }
        }
        return null;
    }

    public Maze2D(String[] maze2D) throws IllegalFormatException {
        this.rows = maze2D.length;
        this.columns = this.findMaxRowLength(maze2D);
        this.maze = new char[this.rows][this.columns];
        for (int row = 0; row < this.rows; ++row) {
            if (maze2D[row].length() < this.columns) {
                String string = "";
                for (int i = 0; i < this.columns - maze2D[row].length(); ++i) {
                    string = string.concat(String.valueOf(Symbol.EMPTY.value()));
                }
                maze2D[row] = maze2D[row].concat(string);
            }
            for (int column = 0; column < this.columns; ++column) {
                char charPoint;
                this.maze[row][column] = charPoint = maze2D[row].charAt(column);
                if (this.maze[row][column] == Symbol.GOAL.value()) {
                    this.goalLoc = new Point(column, row);
                    continue;
                }
                if (this.maze[row][column] != Symbol.START.value()) continue;
                this.initialLoc = new Point(column, row);
            }
        }
        if (this.getInitialLoc() == null) {
            throw new IllegalArgumentException("No initial location. Use the symbol S");
        }
        if (this.getGoalLoc() == null) {
            throw new IllegalArgumentException("No goal location. Use the symbol G");
        }
    }

    private int findMaxRowLength(String[] maze) {
        int max = 0;
        for (String rowMaze : maze) {
            if (rowMaze.length() <= max) continue;
            max = rowMaze.length();
        }
        return max;
    }

    private int findMaxRowLength(char[][] maze) {
        int max = 0;
        for (int row = 0; row < maze.length; ++row) {
            if (maze[row].length <= max) continue;
            max = maze[row].length;
        }
        return max;
    }

    public static Maze2D read(File file) throws IOException {
        String line;
        ArrayList<String> array = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(file));
        while ((line = br.readLine()) != null) {
            array.add(line);
        }
        br.close();
        return new Maze2D((String[])array.toArray());
    }

    public boolean isFree(Point p) {
        return FREE_TILES.contains(Character.valueOf(this.maze[p.y][p.x]));
    }

    public List<Point> getMazePoints() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int row = 0; row < this.rows; ++row) {
            for (int column = 0; column < this.columns; ++column) {
                points.add(new Point(column, row));
            }
        }
        return points;
    }

    public void updateLocation(Point p, Symbol symbol) {
        int row = p.y;
        int column = p.x;
        this.maze[row][column] = symbol.value();
    }

    public void updateRectangle(Point a, Point b, Symbol symbol) {
        int xfrom = a.x < b.x ? a.x : b.x;
        int xto = a.x > b.x ? a.x : b.x;
        int yfrom = a.y < b.y ? a.y : b.y;
        int yto = a.y > b.y ? a.y : b.y;
        for (int x = xfrom; x <= xto; ++x) {
            for (int y = yfrom; y <= yto; ++y) {
                this.updateLocation(new Point(x, y), symbol);
            }
        }
    }

    public void putObstacle(Point p) {
        this.updateLocation(p, Symbol.OCCUPIED);
    }

    public void removeObstacle(Point p) {
        this.updateLocation(p, Symbol.EMPTY);
    }

    public void putObstacleRectangle(Point a, Point b) {
        this.updateRectangle(a, b, Symbol.OCCUPIED);
    }

    public void removeObstacleRectangle(Point a, Point b) {
        this.updateRectangle(a, b, Symbol.EMPTY);
    }

    public String getReplacedMazeString(List<Map<Point, Character>> replacements) {
        String[] stringMaze = this.toStringArray();
        for (Map<Point, Character> replacement : replacements) {
            for (Point p : replacement.keySet()) {
                int row = p.y;
                int column = p.x;
                char c = stringMaze[row].charAt(column);
                if (c == Symbol.START.value() || c == Symbol.GOAL.value()) continue;
                stringMaze[row] = Maze2D.replaceChar(stringMaze[row], column, replacement.get(p).charValue());
            }
        }
        String output = "";
        for (String line : stringMaze) {
            output = output + String.format("%s%n", line);
        }
        return output;
    }

    public String getStringMazeFilled(Collection<Point> points, char symbol) {
        HashMap<Point, Character> replacements = new HashMap<Point, Character>();
        for (Point p : points) {
            replacements.put(p, Character.valueOf(symbol));
        }
        return this.getReplacedMazeString(Collections.singletonList(replacements));
    }

    private static String replaceChar(String line, int position, char c) {
        StringBuilder l = new StringBuilder(line);
        l.setCharAt(position, c);
        return l.toString();
    }

    public boolean validLocation(Point loc) {
        try {
            return this.isFree(loc);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
    }

    public boolean pointInBounds(Point loc) {
        return loc.x >= 0 && loc.x < this.columns && loc.y >= 0 && loc.y < this.rows;
    }

    public Collection<Point> validLocationsFrom(Point loc) {
        HashSet<Point> validMoves = new HashSet<Point>();
        for (int row = -1; row <= 1; ++row) {
            for (int column = -1; column <= 1; ++column) {
                try {
                    if (!this.isFree(new Point(loc.x + column, loc.y + row))) continue;
                    validMoves.add(new Point(loc.x + column, loc.y + row));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        validMoves.remove(loc);
        return validMoves;
    }

    public char[][] getMazeCharArray() {
        return this.maze;
    }

    public String[] toStringArray() {
        char[][] chars = this.getMazeCharArray();
        String[] str = new String[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            str[i] = String.copyValueOf(chars[i]);
        }
        return str;
    }

    public String toString() {
        String output = "";
        String[] stringArray = this.toStringArray();
        for (int i = 0; i < this.maze.length; ++i) {
            output = output + String.format("%s%n", stringArray[i]);
        }
        return output;
    }

    public Set<Point> diff(Maze2D to) {
        char[][] maze1 = this.getMazeCharArray();
        char[][] maze2 = to.getMazeCharArray();
        HashSet<Point> differentLocations = new HashSet<Point>();
        for (int row = 0; row < this.rows; ++row) {
            for (int column = 0; column < this.columns; ++column) {
                if (maze1[row][column] == maze2[row][column]) continue;
                differentLocations.add(new Point(column, row));
            }
        }
        return differentLocations;
    }

    public char[][] getMaze() {
        return this.maze;
    }

    public Point getInitialLoc() {
        return this.initialLoc;
    }

    public Point getGoalLoc() {
        return this.goalLoc;
    }

    public static Maze2D empty(int size) {
        char[][] maze = new char[size][size];
        for (int i = 0; i < size; ++i) {
            Arrays.fill(maze[i], Symbol.EMPTY.value());
        }
        maze[0][0] = Symbol.START.value();
        maze[size][size] = Symbol.GOAL.value();
        return new Maze2D(maze);
    }

    public static enum Symbol {
        OCCUPIED('X'),
        EMPTY(' '),
        START('S'),
        GOAL('G'),
        VISITED('.');

        public final char character;

        private Symbol(char symbol) {
            this.character = symbol;
        }

        public char value() {
            return this.character;
        }

        public static Symbol parse(char c) {
            for (Symbol s : Symbol.values()) {
                if (s.character != c) continue;
                return s;
            }
            return OCCUPIED;
        }
    }
}

