/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.hipster.util.examples.maze;

import es.usc.citius.hipster.model.Node;
import es.usc.citius.hipster.util.examples.maze.Maze2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class MazeSearch {
    private MazeSearch() {
    }

    public static void printSearch(Iterator<? extends Node<?, Point, ?>> it, Maze2D maze) throws InterruptedException {
        HashSet<Point> explored = new HashSet<Point>();
        while (it.hasNext()) {
            Node<?, Point, ?> currentNode = it.next();
            if (currentNode.previousNode() != null) {
                explored.add((Point)currentNode.previousNode().state());
            }
            ArrayList<Point> statePath = new ArrayList<Point>();
            for (Node current : currentNode.path()) {
                statePath.add((Point)current.state());
            }
            System.out.println(MazeSearch.getMazeStringSolution(maze, explored, statePath));
            Thread.sleep(50L);
            if (!currentNode.state().equals(maze.getGoalLoc())) continue;
            return;
        }
    }

    public static void clearOutput(int newlines) {
        char[] chars = new char[newlines];
        Arrays.fill(chars, '\n');
        System.out.println(chars);
    }

    public static String getMazeStringSolution(Maze2D maze, Collection<Point> explored, Collection<Point> path) {
        ArrayList<Map<Point, Character>> replacements = new ArrayList<Map<Point, Character>>();
        HashMap<Point, Character> replacement = new HashMap<Point, Character>();
        for (Point p : explored) {
            replacement.put(p, Character.valueOf('.'));
        }
        replacements.add(replacement);
        replacement = new HashMap();
        for (Point p : path) {
            replacement.put(p, Character.valueOf('*'));
        }
        replacements.add(replacement);
        return maze.getReplacedMazeString(replacements);
    }

    public static final class Result {
        public static final Result NO_RESULT = new Result(Collections.EMPTY_LIST, Double.POSITIVE_INFINITY);
        private List<Point> path;
        private Double cost;

        public Result(List<Point> path, Double cost) {
            this.path = path;
            this.cost = cost;
        }

        public Double getCost() {
            return this.cost;
        }

        public List<Point> getPath() {
            return this.path;
        }

        public int hashCode() {
            int hash = 3;
            hash = 83 * hash + (this.path != null ? this.path.hashCode() : 0);
            hash = 83 * hash + (this.cost != null ? this.cost.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Result other = (Result)obj;
            if (!(this.path == other.path || this.path != null && this.path.equals(other.path))) {
                return false;
            }
            return this.cost == other.cost || this.cost != null && this.cost.equals(other.cost);
        }
    }
}

