/*
 * Decompiled with CFR 0.152.
 */
package es.usc.citius.lab.hipster.collections.adapter;

import es.usc.citius.lab.hipster.collections.FibonacciHeap;
import es.usc.citius.lab.hipster.collections.adapter.PriorityEvaluator;
import java.util.AbstractQueue;
import java.util.Iterator;

public class PriorityFibonacciQueue<N>
extends AbstractQueue<N> {
    private final FibonacciHeap<N> heap = new FibonacciHeap();
    private PriorityEvaluator<N> evaluator;

    public PriorityFibonacciQueue(PriorityEvaluator<N> evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public Iterator<N> iterator() {
        return new Iterator<N>(){

            @Override
            public boolean hasNext() {
                return PriorityFibonacciQueue.this.heap.size() > 0;
            }

            @Override
            public N next() {
                return PriorityFibonacciQueue.this.heap.dequeueMin().getValue();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.heap.size();
    }

    @Override
    public boolean offer(N n) {
        this.heap.enqueue(n, this.evaluator.getPriority(n));
        return true;
    }

    @Override
    public N poll() {
        return this.heap.dequeueMin().getValue();
    }

    @Override
    public N peek() {
        return this.heap.min().getValue();
    }
}

