/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.collections;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class BucketMap
implements Map {
    private static final int DEFAULT_BUCKETS = 255;
    private final Node[] m_buckets;
    private final Object[] m_locks;

    private final int getHash(Object key) {
        int hash = key.hashCode() % this.m_buckets.length;
        return hash < 0 ? hash * -1 : hash;
    }

    public final Set keySet() {
        HashSet<Object> keySet = new HashSet<Object>();
        int i = 0;
        while (i < this.m_buckets.length) {
            Object object = this.m_locks[i];
            synchronized (object) {
                Node n = this.m_buckets[i];
                while (n != null) {
                    keySet.add(n.key);
                    n = n.next;
                }
            }
            ++i;
        }
        return keySet;
    }

    public final int size() {
        int cnt = 0;
        int i = 0;
        while (i < this.m_buckets.length) {
            Object object = this.m_locks[i];
            synchronized (object) {
                Node n = this.m_buckets[i];
                while (n != null) {
                    ++cnt;
                    n = n.next;
                }
            }
            ++i;
        }
        return cnt;
    }

    public final Object put(Object key, Object value) {
        if (key == null || value == null) {
            return null;
        }
        int hash = this.getHash(key);
        Object object = this.m_locks[hash];
        synchronized (object) {
            Node n = this.m_buckets[hash];
            if (n == null) {
                n = new Node();
                n.key = key;
                n.value = value;
                this.m_buckets[hash] = n;
                return value;
            }
            Node next = n;
            while (next != null) {
                n = next;
                if (n.key.equals(key)) {
                    Object returnVal = n.value;
                    n.value = value;
                    return returnVal;
                }
                next = next.next;
            }
            Node newNode = new Node();
            newNode.key = key;
            newNode.value = value;
            n.next = newNode;
        }
        return null;
    }

    public final Object get(Object key) {
        if (key == null) {
            return null;
        }
        int hash = this.getHash(key);
        Object object = this.m_locks[hash];
        synchronized (object) {
            Node n = this.m_buckets[hash];
            while (n != null) {
                if (n.key.equals(key)) {
                    return n.value;
                }
                n = n.next;
            }
        }
        return null;
    }

    public final boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        int hash = this.getHash(key);
        Object object = this.m_locks[hash];
        synchronized (object) {
            Node n = this.m_buckets[hash];
            while (n != null) {
                if (n.key.equals(key)) {
                    return true;
                }
                n = n.next;
            }
        }
        return false;
    }

    public final boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        int i = 0;
        while (i < this.m_buckets.length) {
            Object object = this.m_locks[i];
            synchronized (object) {
                Node n = this.m_buckets[i];
                while (n != null) {
                    if (n.value.equals(value)) {
                        return true;
                    }
                    n = n.next;
                }
            }
            ++i;
        }
        return false;
    }

    public final Collection values() {
        HashSet<Object> valueSet = new HashSet<Object>();
        int i = 0;
        while (i < this.m_buckets.length) {
            Object object = this.m_locks[i];
            synchronized (object) {
                Node n = this.m_buckets[i];
                while (n != null) {
                    valueSet.add(n.value);
                    n = n.next;
                }
            }
            ++i;
        }
        return valueSet;
    }

    public final Set entrySet() {
        HashSet<Node> entrySet = new HashSet<Node>();
        int i = 0;
        while (i < this.m_buckets.length) {
            Object object = this.m_locks[i];
            synchronized (object) {
                Node n = this.m_buckets[i];
                while (n != null) {
                    entrySet.add(n);
                    n = n.next;
                }
            }
            ++i;
        }
        return entrySet;
    }

    public final void putAll(Map other) {
        Iterator i = other.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            this.put(key, other.get(key));
        }
    }

    public final Object remove(Object key) {
        if (key == null) {
            return null;
        }
        int hash = this.getHash(key);
        Object object = this.m_locks[hash];
        synchronized (object) {
            Node n = this.m_buckets[hash];
            Node prev = null;
            while (n != null) {
                if (n.key.equals(key)) {
                    if (prev == null) {
                        this.m_buckets[hash] = n.next;
                    } else {
                        prev.next = n.next;
                    }
                    return n.value;
                }
                prev = n;
                n = n.next;
            }
        }
        return null;
    }

    public final boolean isEmpty() {
        int i = 0;
        while (i < this.m_buckets.length) {
            if (this.m_buckets[i] != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final void clear() {
        int i = 0;
        while (i < this.m_buckets.length) {
            this.m_buckets[i] = null;
            ++i;
        }
    }

    public BucketMap() {
        this(255);
    }

    public BucketMap(int numBuckets) {
        int size = Math.max(17, numBuckets);
        if (size % 2 == 0) {
            --size;
        }
        this.m_buckets = new Node[size];
        this.m_locks = new Object[size];
        int i = 0;
        while (i < size) {
            this.m_locks[i] = new Object();
            ++i;
        }
    }

    private static final class Node
    implements Map.Entry {
        protected Object key;
        protected Object value;
        protected Node next;

        public final Object getKey() {
            return this.key;
        }

        public final Object getValue() {
            return this.value;
        }

        public final Object setValue(Object val) {
            Object retVal = this.value;
            this.value = val;
            return retVal;
        }

        Node() {
        }
    }
}

