/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component.example_im;

import org.apache.avalon.excalibur.component.example_im.ExampleInstrumentable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.excalibur.instrument.CounterInstrument;
import org.apache.excalibur.instrument.Instrument;
import org.apache.excalibur.instrument.Instrumentable;
import org.apache.excalibur.instrument.ValueInstrument;

public class DefaultExampleInstrumentable
extends AbstractLogEnabled
implements ExampleInstrumentable,
Startable,
Runnable,
Instrumentable {
    public static final String INSTRUMENT_RANDOM_QUICK_NAME = "random-quick";
    public static final String INSTRUMENT_RANDOM_SLOW_NAME = "random-slow";
    public static final String INSTRUMENT_RANDOM_RANDOM_NAME = "random-random";
    public static final String INSTRUMENT_COUNTER_QUICK_NAME = "counter-quick";
    public static final String INSTRUMENT_COUNTER_SLOW_NAME = "counter-slow";
    public static final String INSTRUMENT_COUNTER_RANDOM_NAME = "counter-random";
    public static final String INSTRUMENT_DOACTION_NAME = "doaction-counter";
    private String m_instrumentableName;
    private ValueInstrument m_randomQuickInstrument = new ValueInstrument("random-quick");
    private ValueInstrument m_randomSlowInstrument = new ValueInstrument("random-slow");
    private ValueInstrument m_randomRandomInstrument = new ValueInstrument("random-random");
    private CounterInstrument m_counterQuickInstrument = new CounterInstrument("counter-quick");
    private CounterInstrument m_counterSlowInstrument = new CounterInstrument("counter-slow");
    private CounterInstrument m_counterRandomInstrument = new CounterInstrument("counter-random");
    private CounterInstrument m_doActionInstrument = new CounterInstrument("doaction-counter");
    private Thread m_runner;

    public void doAction() {
        this.getLogger().debug("ExampleInstrumentable.doAction() called.");
        this.m_doActionInstrument.increment();
    }

    public void start() {
        if (this.m_runner == null) {
            this.m_runner = new Thread((Runnable)this, "ExampleInstrumentableRunner");
            this.m_runner.start();
        }
    }

    public void stop() {
        if (this.m_runner != null) {
            this.m_runner.interrupt();
            this.m_runner = null;
        }
    }

    public void run() {
        int counter = 0;
        while (this.m_runner != null) {
            block4: {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    if (this.m_runner != null) break block4;
                    return;
                }
            }
            this.m_randomQuickInstrument.setValue((int)(Math.random() * 100.0));
            this.m_counterQuickInstrument.increment();
            if (++counter >= 20) {
                this.m_randomSlowInstrument.setValue((int)(Math.random() * 100.0));
                this.m_counterSlowInstrument.increment();
                counter = 0;
            }
            if (!(100.0 * Math.random() < 10.0)) continue;
            this.m_randomRandomInstrument.setValue((int)(Math.random() * 100.0));
            this.m_counterRandomInstrument.increment();
        }
    }

    public void setInstrumentableName(String name) {
        this.m_instrumentableName = name;
    }

    public String getInstrumentableName() {
        return this.m_instrumentableName;
    }

    public Instrument[] getInstruments() {
        return new Instrument[]{this.m_randomQuickInstrument, this.m_randomSlowInstrument, this.m_randomRandomInstrument, this.m_counterQuickInstrument, this.m_counterSlowInstrument, this.m_counterRandomInstrument, this.m_doActionInstrument};
    }

    public Instrumentable[] getChildInstrumentables() {
        return Instrumentable.EMPTY_INSTRUMENTABLE_ARRAY;
    }
}

