/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component.example_im;

import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import org.apache.avalon.excalibur.component.ExcaliburComponentManagerCreator;
import org.apache.avalon.excalibur.component.example_im.ExampleInstrumentable;
import org.apache.avalon.framework.service.ServiceManager;

public class Main {
    private static ExcaliburComponentManagerCreator m_componentManagerCreator;

    private Main() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.out.println("Running the InstrumentManager Example Application");
        m_componentManagerCreator = new ExcaliburComponentManagerCreator(null, new File("../conf/logkit.xml"), new File("../conf/roles.xml"), new File("../conf/components.xml"), new File("../conf/instrument.xml"));
        ServiceManager serviceManager = m_componentManagerCreator.getServiceManager();
        ExampleInstrumentable instrumentable = (ExampleInstrumentable)serviceManager.lookup(ExampleInstrumentable.ROLE);
        try {
            boolean quit = false;
            while (!quit) {
                System.out.println("Enter the number of times that exampleAction should be called, or 'q' to quit.");
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                System.out.print(" : ");
                String cntStr = in.readLine();
                if (cntStr == null || cntStr.equalsIgnoreCase("q")) {
                    quit = true;
                    continue;
                }
                if (cntStr.equalsIgnoreCase("gc")) {
                    System.gc();
                    continue;
                }
                try {
                    int concurrent = 100;
                    CyclicBarrier barrier = new CyclicBarrier(concurrent);
                    int cnt = Integer.parseInt(cntStr);
                    int average = Math.max(cnt / concurrent, 1);
                    while (cnt > 0) {
                        Thread t = new Thread(new ActionRunner(instrumentable, Math.min(average, cnt), barrier));
                        t.start();
                        if (cnt > 0) {
                            cnt -= average;
                        }
                        if (cnt >= 0) continue;
                        cnt = 0;
                    }
                }
                catch (NumberFormatException e) {
                }
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            serviceManager.release((Object)instrumentable);
            instrumentable = null;
            m_componentManagerCreator.dispose();
            throw throwable;
        }
        serviceManager.release((Object)instrumentable);
        instrumentable = null;
        m_componentManagerCreator.dispose();
        System.out.println();
        System.out.println("Exiting...");
        System.exit(0);
    }

    private static final class ActionRunner
    implements Runnable {
        private final int m_numIterations;
        private final ExampleInstrumentable m_instrumentable;
        private final CyclicBarrier m_barrier;

        protected ActionRunner(ExampleInstrumentable instrumentable, int numIterations, CyclicBarrier barrier) {
            this.m_numIterations = numIterations;
            this.m_instrumentable = instrumentable;
            this.m_barrier = barrier;
        }

        public void run() {
            for (int i = 0; i < this.m_numIterations; ++i) {
                this.m_instrumentable.doAction();
            }
            try {
                this.m_barrier.barrier();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

