/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import org.apache.avalon.excalibur.component.ComponentHandler;
import org.apache.avalon.excalibur.component.DefaultComponentFactory;
import org.apache.avalon.excalibur.component.LogkitLoggerManager;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.excalibur.pool.ResourceLimitingPool;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;

public class PoolableComponentHandler
extends ComponentHandler {
    public static final int DEFAULT_MAX_POOL_SIZE = 8;
    private final DefaultComponentFactory m_factory;
    private final ResourceLimitingPool m_pool;
    private boolean m_initialized = false;
    private boolean m_disposed = false;

    protected PoolableComponentHandler(Class componentClass, Configuration config, ComponentManager manager, Context context, RoleManager roles, LogkitLoggerManager logkit) throws Exception {
        this(new DefaultComponentFactory(componentClass, config, manager, context, roles, logkit), config);
    }

    public PoolableComponentHandler(DefaultComponentFactory factory, Configuration config) throws Exception {
        this.m_factory = factory;
        int poolMax = config.getAttributeAsInteger("pool-max", 8);
        boolean poolMaxStrict = config.getAttributeAsBoolean("pool-max-strict", false);
        boolean poolBlocking = config.getAttributeAsBoolean("pool-blocking", true);
        long poolTimeout = config.getAttributeAsLong("pool-timeout", 0L);
        long poolTrimInterval = config.getAttributeAsLong("pool-trim-interval", 0L);
        this.m_pool = new ResourceLimitingPool((ObjectFactory)this.m_factory, poolMax, poolMaxStrict, poolBlocking, poolTimeout, poolTrimInterval);
    }

    public void initialize() {
        if (this.m_initialized) {
            return;
        }
        this.m_factory.setLogger(this.getLogkitLogger());
        this.m_factory.enableLogging(this.getLogger());
        this.m_pool.enableLogging(this.getLogger());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("ComponentHandler initialized for: " + this.m_factory.getCreatedClass().getName());
        }
        this.m_initialized = true;
    }

    protected Component doGet() throws Exception {
        if (!this.m_initialized) {
            throw new IllegalStateException("You cannot get a component from an uninitialized holder.");
        }
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot get a component from a disposed holder");
        }
        return (Component)this.m_pool.get();
    }

    protected void doPut(Component component) {
        if (!this.m_initialized) {
            throw new IllegalStateException("You cannot put a component in an uninitialized holder.");
        }
        this.m_pool.put((Poolable)component);
    }

    public void dispose() {
        this.m_pool.dispose();
        if (this.m_factory instanceof Disposable) {
            this.m_factory.dispose();
        }
        this.m_disposed = true;
    }

    protected ResourceLimitingPool getPool() {
        return this.m_pool;
    }
}

