/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.excalibur.source.SourceUtil;

public final class SourceParameters
implements Serializable,
Cloneable {
    private Map names = new HashMap(5);

    private final String parseName(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    break;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                        i += 2;
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        String rest = s.substring(i);
                        sb.append(rest);
                        if (rest.length() != 2) break;
                        ++i;
                        break;
                    }
                }
                default: {
                    sb.append(c);
                    break;
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static final SourceParameters create(Configuration conf) {
        Configuration[] children = conf.getChildren();
        if (children != null && children.length > 0) {
            SourceParameters pars = new SourceParameters();
            int i = 0;
            while (i < children.length) {
                String value;
                String name = children[i].getName();
                try {
                    String string = children[i].getValue();
                }
                catch (ConfigurationException local) {
                    value = "";
                }
                pars.setParameter(name, value);
                ++i;
            }
            return pars;
        }
        return null;
    }

    public final void setParameter(String name, String value) {
        ArrayList<String> list;
        if (this.names.containsKey(name)) {
            ArrayList arrayList = (ArrayList)this.names.get(name);
        } else {
            list = new ArrayList<String>(3);
            this.names.put(name, list);
        }
        list.add(value);
    }

    public final String getParameter(String name) {
        if (this.names.containsKey(name)) {
            return (String)((ArrayList)this.names.get(name)).get(0);
        }
        return null;
    }

    public final String getParameter(String name, String defaultValue) {
        if (this.names.containsKey(name)) {
            return (String)((ArrayList)this.names.get(name)).get(0);
        }
        return defaultValue;
    }

    public final int getParameterAsInteger(String name, int defaultValue) {
        if (this.names.containsKey(name)) {
            return new Integer((String)((ArrayList)this.names.get(name)).get(0));
        }
        return defaultValue;
    }

    public final boolean getParameterAsBoolean(String name, boolean defaultValue) {
        if (this.names.containsKey(name)) {
            return new Boolean((String)((ArrayList)this.names.get(name)).get(0));
        }
        return defaultValue;
    }

    public final boolean containsParameter(String name) {
        return this.names.containsKey(name);
    }

    public final Iterator getParameterValues(String name) {
        if (this.names.containsKey(name)) {
            ArrayList list = (ArrayList)this.names.get(name);
            return ((AbstractList)list).iterator();
        }
        return null;
    }

    public final Iterator getParameterNames() {
        return this.names.keySet().iterator();
    }

    public final Parameters getFirstParameters() {
        Parameters result = new Parameters();
        Iterator iter = this.getParameterNames();
        while (iter.hasNext()) {
            String parName = (String)iter.next();
            result.setParameter(parName, this.getParameter(parName));
        }
        return result;
    }

    public final String getQueryString() {
        StringBuffer result = new StringBuffer();
        Iterator iter = this.names.keySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Iterator listIterator = ((AbstractList)((ArrayList)this.names.get(key))).iterator();
            while (listIterator.hasNext()) {
                if (!first) {
                    result.append('&');
                }
                String value = (String)listIterator.next();
                result.append(key).append('=').append(value);
                first = false;
            }
        }
        return result.length() == 0 ? null : result.toString();
    }

    public final String getEncodedQueryString() {
        StringBuffer result = new StringBuffer();
        Iterator iter = this.names.keySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Iterator listIterator = ((AbstractList)((ArrayList)this.names.get(key))).iterator();
            while (listIterator.hasNext()) {
                if (!first) {
                    result.append('&');
                }
                String value = (String)listIterator.next();
                result.append(key).append('=').append(SourceUtil.encode(value));
                first = false;
            }
        }
        return result.length() == 0 ? null : result.toString();
    }

    public final void add(SourceParameters parameters) {
        if (parameters != null) {
            Iterator names = parameters.getParameterNames();
            while (names.hasNext()) {
                String name = (String)names.next();
                Iterator values = parameters.getParameterValues(name);
                while (values.hasNext()) {
                    String value = (String)values.next();
                    this.setParameter(name, value);
                }
            }
        }
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer("SourceParameters: {");
        Iterator names = this.getParameterNames();
        boolean firstName = true;
        while (names.hasNext()) {
            String name = (String)names.next();
            if (!firstName) {
                buffer.append(", ");
            } else {
                firstName = false;
            }
            buffer.append(name).append(" = (");
            Iterator values = this.getParameterValues(name);
            boolean firstValue = true;
            while (values.hasNext()) {
                String value = (String)values.next();
                if (!firstValue) {
                    buffer.append(", ");
                } else {
                    firstValue = false;
                }
                buffer.append(value);
            }
            buffer.append(')');
        }
        buffer.append('}');
        return buffer.toString();
    }

    public final Object clone() {
        SourceParameters newObject = new SourceParameters();
        Iterator names = this.getParameterNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            Iterator values = this.getParameterValues(name);
            while (values.hasNext()) {
                String value = (String)values.next();
                newObject.setParameter(name, value);
            }
        }
        return newObject;
    }

    public final boolean hasParameters() {
        return this.names.size() > 0;
    }

    public final void setSingleParameterValue(String name, String value) {
        this.removeParameter(name);
        this.setParameter(name, value);
    }

    public final void removeParameter(String name) {
        if (this.names.containsKey(name)) {
            this.names.remove(name);
        }
    }

    public SourceParameters() {
    }

    public SourceParameters(String queryString) {
        if (queryString != null) {
            StringTokenizer st = new StringTokenizer(queryString, "&");
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                int pos = pair.indexOf(61);
                if (pos == -1) continue;
                this.setParameter(this.parseName(pair.substring(0, pos)), this.parseName(pair.substring(pos + 1, pair.length())));
            }
        }
    }
}

