/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceParameters;

public final class SourceUtil {
    private static final char[] alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    static BitSet charactersDontNeedingEncoding = new BitSet(256);
    static final int characterCaseDiff = 32;

    public static final String appendParameters(String uri, Parameters parameters) {
        if (parameters != null) {
            int separator;
            StringBuffer buffer = new StringBuffer(uri);
            String[] keys = parameters.getNames();
            int n = separator = uri.indexOf("?") == -1 ? 63 : 38;
            if (keys != null) {
                int i = 0;
                while (i < keys.length) {
                    String current = keys[i];
                    buffer.append((char)separator).append(current).append('=').append(SourceUtil.encode(parameters.getParameter(current, null)));
                    separator = 38;
                    ++i;
                }
            }
            return buffer.toString();
        }
        return uri;
    }

    public static final String appendParameters(String uri, SourceParameters parameters) {
        if (parameters != null) {
            StringBuffer buffer = new StringBuffer(uri);
            Iterator keys = parameters.getParameterNames();
            int separator = uri.indexOf("?") == -1 ? 63 : 38;
            while (keys.hasNext()) {
                String current = (String)keys.next();
                Iterator values = parameters.getParameterValues(current);
                while (values.hasNext()) {
                    buffer.append((char)separator).append(current).append('=').append(SourceUtil.encode((String)values.next()));
                    separator = 38;
                }
            }
            return buffer.toString();
        }
        return uri;
    }

    public static final String encodeBASE64(String s) {
        return SourceUtil.encodeBASE64(s.getBytes());
    }

    public static final String encodeBASE64(byte[] octetString) {
        int bits6;
        int bits24;
        char[] out = new char[((octetString.length - 1) / 3 + 1) * 4];
        int outIndex = 0;
        int i = 0;
        while (i + 3 <= octetString.length) {
            bits24 = (octetString[i++] & 0xFF) << 16;
            bits24 |= (octetString[i++] & 0xFF) << 8;
            bits6 = ((bits24 |= octetString[i++] & 0xFF) & 0xFC0000) >> 18;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0x3F000) >> 12;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0xFC0) >> 6;
            out[outIndex++] = alphabet[bits6];
            bits6 = bits24 & 0x3F;
            out[outIndex++] = alphabet[bits6];
        }
        if (octetString.length - i == 2) {
            bits24 = (octetString[i] & 0xFF) << 16;
            bits6 = ((bits24 |= (octetString[i + 1] & 0xFF) << 8) & 0xFC0000) >> 18;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0x3F000) >> 12;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0xFC0) >> 6;
            out[outIndex++] = alphabet[bits6];
            out[outIndex++] = 61;
        } else if (octetString.length - i == 1) {
            bits24 = (octetString[i] & 0xFF) << 16;
            bits6 = (bits24 & 0xFC0000) >> 18;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0x3F000) >> 12;
            out[outIndex++] = alphabet[bits6];
            out[outIndex++] = 61;
            out[outIndex++] = 61;
        }
        return new String(out);
    }

    public static final String encode(String s) {
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(32);
        OutputStreamWriter writer = new OutputStreamWriter(buf);
        int i = 0;
        while (i < s.length()) {
            block8: {
                char c = s.charAt(i);
                if (charactersDontNeedingEncoding.get(c)) {
                    out.append(c);
                } else {
                    try {
                        writer.write(c);
                        writer.flush();
                    }
                    catch (IOException e) {
                        buf.reset();
                        break block8;
                    }
                    byte[] ba = buf.toByteArray();
                    int j = 0;
                    while (j < ba.length) {
                        out.append('%');
                        char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                        if (Character.isLetter(ch)) {
                            ch = (char)(ch - 32);
                        }
                        out.append(ch);
                        ch = Character.forDigit(ba[j] & 0xF, 16);
                        if (Character.isLetter(ch)) {
                            ch = (char)(ch - 32);
                        }
                        out.append(ch);
                        ++j;
                    }
                    buf.reset();
                }
            }
            ++i;
        }
        return out.toString();
    }

    public static final File getFile(Source source) {
        String systemId = source.getSystemId();
        if (systemId.startsWith("file:")) {
            return new File(systemId.substring(5));
        }
        return null;
    }

    static {
        int i = 97;
        while (i <= 122) {
            charactersDontNeedingEncoding.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            charactersDontNeedingEncoding.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            charactersDontNeedingEncoding.set(i);
            ++i;
        }
        charactersDontNeedingEncoding.set(45);
        charactersDontNeedingEncoding.set(95);
        charactersDontNeedingEncoding.set(46);
        charactersDontNeedingEncoding.set(42);
        charactersDontNeedingEncoding.set(34);
    }
}

