/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;

public class URLSource
implements Source {
    public static final String HTTP_METHOD = "org.apache.avalon.excalibur.source.Source.http.method";
    public static final String REQUEST_PARAMETERS = "org.apache.avalon.excalibur.source.Source.request.parameters";
    private static boolean checkedURLClass = false;
    private static boolean urlSupportsGetUserInfo = false;
    private static Method urlGetUserInfo = null;
    private static Object[] emptyParams = new Object[0];
    protected final String FILE;
    protected long lastModificationDate;
    protected String systemId;
    protected URL url;
    protected URLConnection connection;
    protected boolean isFile;
    protected boolean gotInfos;
    protected SourceParameters parameters;
    protected boolean isPost = false;
    private static /* synthetic */ Class class$Ljava$net$URL;

    public void init(URL url, Map parameters) throws IOException {
        this.systemId = url.toExternalForm();
        this.isFile = this.systemId.startsWith("file:");
        this.url = url;
        this.gotInfos = false;
        this.isPost = false;
        if (parameters != null) {
            this.parameters = (SourceParameters)parameters.get(REQUEST_PARAMETERS);
            String method = (String)parameters.get(HTTP_METHOD);
            if ("POST".equalsIgnoreCase(method)) {
                this.isPost = true;
            }
        }
        if (!this.isFile && this.parameters != null && this.parameters.hasParameters() && !this.isPost) {
            boolean first;
            StringBuffer urlBuffer = new StringBuffer(this.systemId);
            Iterator i = this.parameters.getParameterNames();
            boolean bl = first = this.systemId.indexOf(63) == -1;
            if (first) {
                urlBuffer.append('?');
            }
            while (i.hasNext()) {
                String key = (String)i.next();
                Iterator values = this.parameters.getParameterValues(key);
                while (values.hasNext()) {
                    String value = SourceUtil.encode((String)values.next());
                    if (!first) {
                        urlBuffer.append('&');
                    }
                    first = false;
                    urlBuffer.append(key);
                    urlBuffer.append('=');
                    urlBuffer.append(value);
                }
            }
            this.url = new URL(urlBuffer.toString());
            this.parameters = null;
        }
    }

    protected void getInfos() {
        if (!this.gotInfos) {
            if (this.isFile) {
                File file = new File(this.systemId.substring("file:".length()));
                this.lastModificationDate = file.lastModified();
            } else if (!this.isPost) {
                try {
                    if (this.connection == null) {
                        this.connection = this.url.openConnection();
                        String userInfo = this.getUserInfo();
                        if (this.url.getProtocol().startsWith("http") && userInfo != null) {
                            this.connection.setRequestProperty("Authorization", "Basic " + SourceUtil.encodeBASE64(userInfo));
                        }
                    }
                    this.lastModificationDate = this.connection.getLastModified();
                }
                catch (IOException ignore) {
                    this.lastModificationDate = 0L;
                }
            } else {
                this.lastModificationDate = 0L;
            }
            this.gotInfos = true;
        }
    }

    public long getLastModified() {
        this.getInfos();
        return this.lastModificationDate;
    }

    public InputStream getInputStream() throws IOException, SourceException {
        this.getInfos();
        InputStream input = null;
        if (this.isFile) {
            input = new FileInputStream(this.systemId.substring("file:".length()));
        } else {
            if (this.connection == null) {
                this.connection = this.url.openConnection();
                String userInfo = this.getUserInfo();
                if (this.url.getProtocol().startsWith("http") && userInfo != null) {
                    this.connection.setRequestProperty("Authorization", "Basic " + SourceUtil.encodeBASE64(userInfo));
                }
                if (this.connection instanceof HttpURLConnection && this.isPost) {
                    StringBuffer buffer = new StringBuffer(2000);
                    Iterator i = this.parameters.getParameterNames();
                    boolean first = true;
                    while (i.hasNext()) {
                        String key = (String)i.next();
                        Iterator values = this.parameters.getParameterValues(key);
                        while (values.hasNext()) {
                            String value = SourceUtil.encode((String)values.next());
                            if (!first) {
                                buffer.append('&');
                            }
                            first = false;
                            buffer.append(key.toString());
                            buffer.append('=');
                            buffer.append(value);
                        }
                    }
                    HttpURLConnection httpCon = (HttpURLConnection)this.connection;
                    httpCon.setDoInput(true);
                    if (buffer.length() > 1) {
                        String postString = buffer.toString();
                        httpCon.setRequestMethod("POST");
                        httpCon.setDoOutput(true);
                        httpCon.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                        httpCon.setRequestProperty("Content-length", Integer.toString(postString.length()));
                        BufferedOutputStream out = new BufferedOutputStream(httpCon.getOutputStream());
                        ((OutputStream)out).write(postString.getBytes());
                        ((OutputStream)out).close();
                    }
                    input = httpCon.getInputStream();
                    this.connection = null;
                    return input;
                }
            }
            input = this.connection.getInputStream();
            this.connection = null;
        }
        return input;
    }

    /*
     * WARNING - void declaration
     */
    protected String getUserInfo() {
        if (checkedURLClass) {
            if (urlSupportsGetUserInfo) {
                try {
                    return (String)urlGetUserInfo.invoke((Object)this.url, emptyParams);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return null;
        }
        try {
            void e;
            urlGetUserInfo = (class$Ljava$net$URL != null ? class$Ljava$net$URL : (class$Ljava$net$URL = URLSource.class$("java.net.URL"))).getMethod("getUserInfo", null);
            String ui = (String)urlGetUserInfo.invoke((Object)this.url, emptyParams);
            checkedURLClass = true;
            urlSupportsGetUserInfo = true;
            return e;
        }
        catch (Exception exception) {
            checkedURLClass = true;
            urlSupportsGetUserInfo = false;
            urlGetUserInfo = null;
            return null;
        }
    }

    public String getSystemId() {
        return this.systemId;
    }

    public SourceValidity getValidity() {
        long lm = this.getLastModified();
        if (lm == -1L) {
            return null;
        }
        return new TimeStampValidity(lm);
    }

    public void discardValidity() {
        this.connection = null;
        this.gotInfos = false;
    }

    public String getMimeType() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public URLSource() {
        this.FILE = "file:";
    }
}

