/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.excalibur.source.SourceUtil;

public final class SourceParameters
implements Serializable,
Cloneable {
    private Map names = new HashMap(5);

    private String parseName(String s) {
        StringBuffer sb = new StringBuffer();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    continue block7;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue block7;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        String rest = s.substring(i);
                        sb.append(rest);
                        if (rest.length() != 2) continue block7;
                        ++i;
                        continue block7;
                    }
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static SourceParameters create(Configuration conf) {
        Configuration[] children = conf.getChildren();
        if (children != null && children.length > 0) {
            SourceParameters pars = new SourceParameters();
            for (int i = 0; i < children.length; ++i) {
                String value;
                String name = children[i].getName();
                try {
                    value = children[i].getValue();
                }
                catch (ConfigurationException local) {
                    value = "";
                }
                pars.setParameter(name, value);
            }
            return pars;
        }
        return null;
    }

    public SourceParameters() {
    }

    public SourceParameters(String queryString) {
        if (queryString != null) {
            StringTokenizer st = new StringTokenizer(queryString, "&");
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                int pos = pair.indexOf(61);
                if (pos == -1) continue;
                this.setParameter(this.parseName(pair.substring(0, pos)), this.parseName(pair.substring(pos + 1, pair.length())));
            }
        }
    }

    public void setParameter(String name, String value) {
        ArrayList list;
        if (this.names.containsKey(name)) {
            list = (ArrayList)this.names.get(name);
        } else {
            list = new ArrayList(3);
            this.names.put(name, list);
        }
        list.add(value);
    }

    public String getParameter(String name) {
        if (this.names.containsKey(name)) {
            return (String)((ArrayList)this.names.get(name)).get(0);
        }
        return null;
    }

    public String getParameter(String name, String defaultValue) {
        if (this.names.containsKey(name)) {
            return (String)((ArrayList)this.names.get(name)).get(0);
        }
        return defaultValue;
    }

    public int getParameterAsInteger(String name, int defaultValue) {
        if (this.names.containsKey(name)) {
            return new Integer((String)((ArrayList)this.names.get(name)).get(0));
        }
        return defaultValue;
    }

    public boolean getParameterAsBoolean(String name, boolean defaultValue) {
        if (this.names.containsKey(name)) {
            return new Boolean((String)((ArrayList)this.names.get(name)).get(0));
        }
        return defaultValue;
    }

    public boolean containsParameter(String name) {
        return this.names.containsKey(name);
    }

    public Iterator getParameterValues(String name) {
        if (this.names.containsKey(name)) {
            ArrayList list = (ArrayList)this.names.get(name);
            return ((AbstractList)list).iterator();
        }
        return null;
    }

    public String[] getParameterValuesAsArray(String name) {
        if (this.names.containsKey(name)) {
            ArrayList list = (ArrayList)this.names.get(name);
            String[] values = new String[list.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = (String)list.get(i);
            }
            return values;
        }
        return null;
    }

    public Iterator getParameterNames() {
        return this.names.keySet().iterator();
    }

    public Parameters getFirstParameters() {
        Parameters result = new Parameters();
        Iterator iter = this.getParameterNames();
        while (iter.hasNext()) {
            String parName = (String)iter.next();
            result.setParameter(parName, this.getParameter(parName));
        }
        return result;
    }

    public String getQueryString() {
        StringBuffer result = new StringBuffer();
        Iterator iter = this.names.keySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Iterator listIterator = ((AbstractList)((ArrayList)this.names.get(key))).iterator();
            while (listIterator.hasNext()) {
                if (!first) {
                    result.append('&');
                }
                String value = (String)listIterator.next();
                result.append(key).append('=').append(value);
                first = false;
            }
        }
        return result.length() == 0 ? null : result.toString();
    }

    public String getEncodedQueryString() {
        StringBuffer result = new StringBuffer();
        Iterator iter = this.names.keySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Iterator listIterator = ((AbstractList)((ArrayList)this.names.get(key))).iterator();
            while (listIterator.hasNext()) {
                if (!first) {
                    result.append('&');
                }
                String value = (String)listIterator.next();
                result.append(key).append('=').append(SourceUtil.encode(value));
                first = false;
            }
        }
        return result.length() == 0 ? null : result.toString();
    }

    public void add(SourceParameters parameters) {
        if (null != parameters) {
            Iterator names = parameters.getParameterNames();
            while (names.hasNext()) {
                String name = (String)names.next();
                Iterator values = parameters.getParameterValues(name);
                while (values.hasNext()) {
                    String value = (String)values.next();
                    this.setParameter(name, value);
                }
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("SourceParameters: {");
        Iterator names = this.getParameterNames();
        boolean firstName = true;
        while (names.hasNext()) {
            String name = (String)names.next();
            if (!firstName) {
                buffer.append(", ");
            } else {
                firstName = false;
            }
            buffer.append(name).append(" = (");
            Iterator values = this.getParameterValues(name);
            boolean firstValue = true;
            while (values.hasNext()) {
                String value = (String)values.next();
                if (!firstValue) {
                    buffer.append(", ");
                } else {
                    firstValue = false;
                }
                buffer.append(value);
            }
            buffer.append(')');
        }
        buffer.append('}');
        return buffer.toString();
    }

    public Object clone() {
        SourceParameters newObject = new SourceParameters();
        Iterator names = this.getParameterNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            Iterator values = this.getParameterValues(name);
            while (values.hasNext()) {
                String value = (String)values.next();
                newObject.setParameter(name, value);
            }
        }
        return newObject;
    }

    public boolean hasParameters() {
        return this.names.size() > 0;
    }

    public void setSingleParameterValue(String name, String value) {
        this.removeParameter(name);
        this.setParameter(name, value);
    }

    public void removeParameter(String name) {
        if (this.names.containsKey(name)) {
            this.names.remove(name);
        }
    }

    public Map getParameterMap() {
        HashMap m = new HashMap(this.names);
        Iterator entries = m.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            ArrayList list = (ArrayList)entry.getValue();
            String[] values = new String[list.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = (String)list.get(i);
            }
            entry.setValue(values);
        }
        return m;
    }
}

