/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.store.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.instrument.CounterInstrument;
import org.apache.excalibur.instrument.Instrument;
import org.apache.excalibur.instrument.Instrumentable;
import org.apache.excalibur.instrument.ValueInstrument;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.store.StoreJanitor;

public class MRUMemoryStore
extends AbstractLogEnabled
implements Store,
Parameterizable,
Serviceable,
Disposable,
ThreadSafe,
Instrumentable {
    private String m_instrumentableName;
    private int m_maxobjects;
    private boolean m_persistent;
    private Hashtable m_cache;
    private LinkedList m_mrulist;
    private Store m_persistentStore;
    private StoreJanitor m_storeJanitor;
    private ServiceManager m_manager;
    private ValueInstrument m_sizeInstrument = new ValueInstrument("size");
    private CounterInstrument m_hitsInstrument = new CounterInstrument("hits");
    private CounterInstrument m_missesInstrument = new CounterInstrument("misses");

    public void service(ServiceManager manager) throws ServiceException {
        this.m_manager = manager;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Looking up " + StoreJanitor.ROLE);
        }
        this.m_storeJanitor = (StoreJanitor)manager.lookup(StoreJanitor.ROLE);
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.m_maxobjects = params.getParameterAsInteger("maxobjects", 100);
        this.m_persistent = params.getParameterAsBoolean("use-persistent-cache", false);
        if (this.m_maxobjects < 1) {
            throw new ParameterException("MRUMemoryStore maxobjects must be at least 1!");
        }
        if (this.m_persistent) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Looking up " + Store.PERSISTENT_STORE);
            }
            try {
                this.m_persistentStore = (Store)this.m_manager.lookup(Store.PERSISTENT_STORE);
            }
            catch (ServiceException se) {
                throw new ParameterException("Unable to look up persistent store.", (Throwable)se);
            }
        }
        this.m_cache = new Hashtable((int)((double)this.m_maxobjects * 1.2));
        this.m_mrulist = new LinkedList();
        this.m_storeJanitor.register(this);
    }

    public void dispose() {
        if (this.m_manager != null) {
            this.getLogger().debug("Disposing component!");
            if (this.m_storeJanitor != null) {
                this.m_storeJanitor.unregister(this);
            }
            this.m_manager.release((Object)this.m_storeJanitor);
            this.m_storeJanitor = null;
            if (this.m_persistent) {
                this.getLogger().debug("Final cache size: " + this.m_cache.size());
                Enumeration enumeration = this.m_cache.keys();
                while (enumeration.hasMoreElements()) {
                    Object key = enumeration.nextElement();
                    if (key == null) continue;
                    try {
                        Object value = this.m_cache.remove(key);
                        if (!this.checkSerializable(value)) continue;
                        this.m_persistentStore.store(key, value);
                    }
                    catch (IOException ioe) {
                        this.getLogger().error("Error in dispose()", (Throwable)ioe);
                    }
                }
            }
            this.m_manager.release((Object)this.m_persistentStore);
            this.m_persistentStore = null;
        }
        this.m_manager = null;
    }

    public synchronized void store(Object key, Object value) {
        this.hold(key, value);
    }

    public synchronized void hold(Object key, Object value) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Holding object in memory:");
            this.getLogger().debug("  key: " + key);
            this.getLogger().debug("  value: " + value);
        }
        while (this.m_mrulist.size() >= this.m_maxobjects) {
            this.free();
        }
        this.m_cache.put(key, value);
        this.m_mrulist.remove(key);
        this.m_mrulist.addFirst(key);
        this.m_sizeInstrument.setValue(this.m_mrulist.size());
    }

    public synchronized Object get(Object key) {
        Object value = this.m_cache.get(key);
        if (value != null) {
            this.m_mrulist.remove(key);
            this.m_mrulist.addFirst(key);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Found key: " + key.toString());
            }
            this.m_hitsInstrument.increment();
            return value;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("NOT Found key: " + key.toString());
        }
        if (this.m_persistent && (value = this.m_persistentStore.get(key)) != null) {
            try {
                if (!this.m_cache.containsKey(key)) {
                    this.hold(key, value);
                }
                this.m_hitsInstrument.increment();
                return value;
            }
            catch (Exception e) {
                this.getLogger().error("Error in get()!", (Throwable)e);
            }
        }
        this.m_missesInstrument.increment();
        return null;
    }

    public synchronized void remove(Object key) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Removing object from store");
            this.getLogger().debug("  key: " + key);
        }
        this.m_cache.remove(key);
        this.m_mrulist.remove(key);
        this.m_sizeInstrument.setValue(this.m_mrulist.size());
        if (this.m_persistent && key != null) {
            this.m_persistentStore.remove(key);
        }
    }

    public synchronized void clear() {
        Enumeration enumeration = this.m_cache.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            if (key == null) continue;
            this.remove(key);
        }
        this.m_sizeInstrument.setValue(0);
    }

    public synchronized boolean containsKey(Object key) {
        if (this.m_persistent) {
            return this.m_cache.containsKey(key) || this.m_persistentStore.containsKey(key);
        }
        return this.m_cache.containsKey(key);
    }

    public synchronized Enumeration keys() {
        return this.m_cache.keys();
    }

    public synchronized int size() {
        return this.m_cache.size();
    }

    public synchronized void free() {
        block8: {
            try {
                if (this.m_cache.size() <= 0) break block8;
                Object key = this.m_mrulist.removeLast();
                Object value = this.m_cache.remove(key);
                if (value == null) {
                    this.getLogger().warn("Concurrency condition in free()");
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Freeing cache.");
                    this.getLogger().debug("  key: " + key);
                    this.getLogger().debug("  value: " + value);
                }
                if (this.m_persistent && this.checkSerializable(value)) {
                    try {
                        this.m_persistentStore.store(key, value);
                    }
                    catch (Exception e) {
                        this.getLogger().error("Error storing object on fs", (Throwable)e);
                    }
                }
                this.m_sizeInstrument.setValue(this.m_mrulist.size());
            }
            catch (NoSuchElementException e) {
                this.getLogger().warn("Concurrency error in free()", (Throwable)e);
            }
            catch (Exception e) {
                this.getLogger().error("Error in free()", (Throwable)e);
            }
        }
    }

    private boolean checkSerializable(Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof Serializable;
    }

    public void setInstrumentableName(String name) {
        this.m_instrumentableName = name;
    }

    public String getInstrumentableName() {
        return this.m_instrumentableName;
    }

    public Instrument[] getInstruments() {
        return new Instrument[]{this.m_sizeInstrument, this.m_hitsInstrument, this.m_missesInstrument};
    }

    public Instrumentable[] getChildInstrumentables() {
        return Instrumentable.EMPTY_INSTRUMENTABLE_ARRAY;
    }
}

