/**
 * (C) Copyright 2011-2015 FastConnect SAS
 * (http://www.fastconnect.fr/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package fr.fastconnect.factory.tibco.bw.maven.deployment;

import org.apache.maven.plugins.annotations.Parameter;

import fr.fastconnect.factory.tibco.bw.maven.compile.CompileEARMojo;
import fr.fastconnect.factory.tibco.bw.maven.packaging.AbstractPackagingMojo;

/**
 * <p>
 * This class inherits from {@link CompileEARMojo} because it will use the
 * EAR generated by this class to deploy it on a TIBCO domain.
 * </p>
 * 
 * @author Mathieu Debove
 *
 */
public class AbstractBWDeployMojo extends AbstractPackagingMojo {
	
	/**
	 * Name of the project once deployed in TIBCO domain
	 */
	@Parameter ( property = deployedProjectNameProperty, required = true )
	protected String deployedProjectName;

	/**
	 * TIBCO domain name
	 */
	@Parameter ( property = domainNameProperty, required = true)
	protected String domainName;

	/**
	 * TIBCO domain username
	 */
	@Parameter ( property = domainUsernameProperty, required = true)
	protected String domainUsername;

	/**
	 * TIBCO domain password
	 */
	@Parameter ( property = domainPasswordProperty, required = true)
	protected String domainPassword;

	@Override
	protected String getArtifactFileExtension() {
		return BWEAR_EXTENSION;
	}

	public boolean skip() {
		return !getProject().getPackaging().startsWith(BWEAR_TYPE); // startsWith to include bw-ear-deploy
	}

}
