/**
 * (C) Copyright 2011-2015 FastConnect SAS
 * (http://www.fastconnect.fr/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package fr.fastconnect.factory.tibco.bw.maven.source;

import java.io.File;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

/**
 * <p>
 * This class is the same as {@link MavenProjectsListMojo} with an additional
 * Mojo parameter. This parameter is used to specify the root POM as defined
 * by the <i>archetype-client-root-project</i> archetype.
 * </p>
 * 
 * @author Mathieu Debove
 *
 */
public class MavenProjectsListWithRootPOMMojo extends MavenProjectsListMojo {
	/**
	 * This is the POM file of the root client project (as generated by
	 * 'archetype-client-root-project').
	 */
	@Parameter ( required = false, property = "rootPOM", defaultValue = "${basedir}/pom.xml" )
	protected File rootPOM;

	@Parameter ( required = false, property = "profileId")
	protected String profileId;

	protected boolean rootPOMExists() {
		return (rootPOM != null && rootPOM.exists());
	}
	
	@Override
	public void execute() throws MojoExecutionException, MojoFailureException {
		super.execute();
		if (!rootPOMExists()) {
			if (rootPOM != null) {
				getLog().warn(rootPOM.getAbsolutePath());
			}
			throw new MojoExecutionException("No root POM was found.");
		}
	}
}
