/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven;

import fr.fastconnect.factory.tibco.bw.maven.AbstractBWMojo;
import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractBWArtifactMojo
extends AbstractBWMojo {
    protected static final String WARN_NO_ARTIFACT_ATTACHED = "Could not attach artifact.";
    @Parameter(property="bw.compile.skip", required=false, defaultValue="false")
    protected Boolean skipCompile;
    @Parameter(property="bw.compile.ear.skip", required=false, defaultValue="false")
    protected Boolean skipEARCompile;
    @Parameter(property="bw.compile.ear.skip.touch", required=false, defaultValue="false")
    protected Boolean touchEARIfSkipped;
    @Parameter(property="bw.compile.projlib.skip", required=false, defaultValue="false")
    protected Boolean skipProjlibCompile;
    @Parameter(property="bw.compile.projlib.skip.touch", required=false, defaultValue="false")
    protected Boolean touchProjlibIfSkipped;
    @Parameter(property="bw.package.skip", required=false, defaultValue="false")
    protected Boolean skipPackage;
    @Parameter(property="bw.package.skip.deploy.pom.touch", required=false, defaultValue="false")
    protected Boolean touchPOMDeployIfSkipped;
    @Parameter(property="bw.package.skip.deploy.descriptor.final.touch", required=false, defaultValue="false")
    protected Boolean touchFinalDeploymentDescriptorIfSkipped;
    @Parameter(property="project.build.finalName", required=true)
    protected String finalName;
    @Parameter(property="project.build.classifier")
    protected String classifier;

    protected abstract String getArtifactFileExtension();

    private Artifact extractArtifact(Artifact a, String type, String classifier) {
        if (a == null) {
            return a;
        }
        DefaultArtifact result = new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getVersionRange(), a.getScope(), type, classifier, (ArtifactHandler)new DefaultArtifactHandler(type));
        return result;
    }

    protected void attachFile(File f, String type, String classifier) {
        Artifact artifact = this.extractArtifact(this.getProject().getArtifact(), type, classifier);
        artifact.setFile(f);
        this.getProject().addAttachedArtifact(artifact);
    }

    protected File getArtifactFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + this.getArtifactFileExtension());
    }

    protected File getOutputFile() {
        return this.getArtifactFile(this.outputDirectory, this.finalName, this.classifier);
    }

    protected void checkOutputDirectory() {
        if (!this.outputDirectory.exists() || !this.outputDirectory.isDirectory()) {
            this.outputDirectory.mkdirs();
        }
    }

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        this.getOutputFile().getParentFile().mkdir();
    }
}

