/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven;

import fr.fastconnect.factory.tibco.bw.maven.exception.BinaryMissingException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.commons.exec.launcher.CommandLauncher;
import org.apache.commons.exec.launcher.CommandLauncherFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Settings;
import org.apache.tools.ant.taskdefs.optional.ReplaceRegExp;

public class AbstractBWMojo
extends AbstractMojo {
    protected static final String BWPROJECT_NOTFOUND = "The BusinessWorks project can't be found.";
    protected static final String BWPROJECT_PREF_LIB_ERROR_MSG = "The BusinessWorks project Designer5.prefs/.designtimelibs can't be copied.";
    protected static final String SKIPPING = "Skipping.";
    public static final String BWEAR_EXTENSION = ".ear";
    public static final String BWEAR_TYPE = "bw-ear";
    protected static final String PROJLIB_EXTENSION = ".projlib";
    public static final String PROJLIB_TYPE = "projlib";
    protected static final String JAR_EXTENSION = ".jar";
    public static final String JAR_TYPE = "jar";
    protected static final String PROPERTIES_EXTENSION = ".properties";
    public static final String POM_TYPE = "pom";
    protected static final String POM_EXTENSION = ".xml";
    public static final String XML_TYPE = "xml";
    protected static final String XML_EXTENSION = ".xml";
    protected static final String TIBCO_HOME_DIR = ".TIBCO";
    protected static final String TIBCO_ALIAS_PREFIX = "tibco.alias.";
    protected static final String FILE_ALIAS_PREFIX = "filealias.pref.";
    protected static final String FILE_ALIAS_PREFIX_ESCAPED = "filealias\\.pref\\.";
    protected static final String ALIASES_FILE = "aliases.properties";
    protected static final String DTL_FILE_NAME = ".designtimelibs";
    protected static final String DESIGNER5_PREFS = "Designer5.prefs";
    @Parameter(property="timeOut", defaultValue="180")
    protected int timeOut;
    @Parameter(property="tibco.home")
    protected File tibcoHome;
    @Parameter(property="tibco.hawk.version")
    protected String hawkVersion;
    @Parameter(property="appmanage.tra.path")
    protected File tibcoAppManageTRAPath;
    @Parameter(property="buildear.tra.path")
    protected File tibcoBuildEARTRAPath;
    @Parameter(property="bwengine.tra.path", required=true)
    protected File tibcoBWEngineTRAPath;
    @Parameter(property="buildlibrary.tra.path")
    protected File tibcoBuildLibraryTRAPath;
    @Parameter(property="designer.tra.path")
    protected File tibcoDesignerTRAPath;
    @Parameter(property="tra.buildear.uses.designer.tra.path")
    protected boolean tibcoBuildEARUseDesignerTRA;
    @Parameter(property="tra.buildlibrary.uses.designer.tra.path")
    protected boolean tibcoBuildLibraryUseDesignerTRA;
    @Parameter(property="tibrv.home.path")
    protected File tibcoRvHomePath;
    protected static final String APPMANAGE_BINARY_NOTFOUND = "The TIBCO AppManage binary can't be found.";
    protected static final String DESIGNER_BINARY_NOTFOUND = "The TIBCO Designer binary can't be found.";
    protected static final String HAWK_BINARY_NOTFOUND = "The TIBCO Hawk binary folder can't be found.";
    @Parameter(property="appmanage.path")
    protected File tibcoAppManagePath;
    @Parameter(property="designer.path")
    protected File tibcoDesignerPath;
    @Parameter(property="bw.hide.library.resources")
    protected boolean hideLibraryResources;
    @Parameter
    protected ArrayList<String> dependenciesIgnored;
    @Parameter(property="project.build.directory", required=true, readonly=true)
    protected File directory;
    @Parameter(property="project.build.test.directory", defaultValue="${project.build.directory}/test", required=true)
    protected File testDirectory;
    @Parameter(property="project.build.test.directory.lib", defaultValue="${project.build.test.directory}/lib", required=true)
    protected File testLibDirectory;
    @Parameter(property="project.build.test.directory.src", defaultValue="${project.build.test.directory}/src", required=true)
    protected File testSrcDirectory;
    @Parameter(property="project.package.directory", defaultValue="${project.build.directory}/package", required=true)
    protected File packageDirectory;
    @Parameter(property="project.build.outputDirectory", required=true)
    protected File outputDirectory;
    @Parameter(property="bw.project.location")
    protected File projectDirectory;
    @Parameter(property="project.build.directory.lib", defaultValue="${project.build.directory}/lib", required=true)
    protected File buildLibDirectory;
    @Parameter(property="project.build.directory.src", defaultValue="${project.build.directory}/src", required=true)
    protected File buildSrcDirectory;
    @Parameter(property="hawk.domain", defaultValue="${tibco.domain.name}")
    protected String hawkDomain;
    @Parameter(property="hawk.subscribe.interval", defaultValue="10")
    protected Integer hawkSubscribeInterval;
    @Parameter(property="hawk.subscribe.retry.count", defaultValue="30")
    protected Integer hawkSubscribeNumberOfRetry;
    @Parameter(property="hawk.rv.service", defaultValue="7474")
    protected String hawkRvService;
    @Parameter(property="hawk.rv.network", defaultValue=";")
    protected String hawkRvNetwork;
    @Parameter(property="hawk.rv.daemon", defaultValue="tcp:7474")
    protected String hawkRvDaemon;
    public static final Pattern mavenPropertyPattern = Pattern.compile("\\$\\{([^}]*)\\}");
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="session", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(property="project.build.sourceEncoding", required=true, readonly=true)
    protected String sourceEncoding;

    protected void checkAppManage() throws MojoExecutionException {
        if (this.tibcoAppManagePath == null || !this.tibcoAppManagePath.exists() || !this.tibcoAppManagePath.isFile()) {
            this.tibcoAppManagePathNotFound();
        }
    }

    private void tibcoAppManagePathNotFound() throws MojoExecutionException {
        throw new BinaryMissingException(APPMANAGE_BINARY_NOTFOUND);
    }

    protected void checkDesigner() throws MojoExecutionException {
        if (this.tibcoDesignerPath == null || !this.tibcoDesignerPath.exists() || !this.tibcoDesignerPath.isFile()) {
            this.tibcoDesignerPathNotFound();
        }
    }

    private void tibcoDesignerPathNotFound() throws MojoExecutionException {
        throw new BinaryMissingException(DESIGNER_BINARY_NOTFOUND);
    }

    protected boolean initHawk(boolean failIfNotFound) throws BinaryMissingException {
        File tibrvj;
        if (this.tibcoRvHomePath == null || !this.tibcoRvHomePath.exists()) {
            if (failIfNotFound) {
                throw new BinaryMissingException(HAWK_BINARY_NOTFOUND);
            }
            this.getLog().info((CharSequence)"Unable to init Hawk.");
            return false;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            this.getLog().debug((CharSequence)"Windows OS");
            this.tibcoRvHomePath = new File(this.tibcoRvHomePath, "bin/");
            tibrvj = new File(this.tibcoRvHomePath, "tibrvj.dll");
            System.load(tibrvj.getAbsolutePath());
        } else {
            this.getLog().debug((CharSequence)"Not Windows OS");
            this.tibcoRvHomePath = new File(this.tibcoRvHomePath, "lib/");
            String osArch = System.getProperty("os.arch");
            tibrvj = null;
            if (osArch.equals("x86")) {
                this.getLog().debug((CharSequence)"x86");
                tibrvj = new File(this.tibcoRvHomePath, "libtibrvj.so");
                System.loadLibrary("tibrvj");
            } else if (osArch.contains("64")) {
                this.getLog().debug((CharSequence)"64");
                tibrvj = new File(this.tibcoRvHomePath, "libtibrvj64.so");
                System.loadLibrary("tibrvj64");
            }
        }
        this.getLog().debug((CharSequence)("Loading system library : " + tibrvj.getAbsolutePath()));
        return true;
    }

    public static AbstractBWMojo propertiesManager(MavenSession session, MavenProject mavenProject) {
        AbstractBWMojo mojo = new AbstractBWMojo();
        mojo.setProject(mavenProject);
        mojo.setSession(session);
        mojo.setSettings(session.getSettings());
        return mojo;
    }

    public String getPropertyValueInSettings(String propertyName, Settings settings) {
        if (settings == null) {
            return null;
        }
        List activeProfiles = settings.getActiveProfiles();
        for (Map.Entry _profileWithId : settings.getProfilesAsMap().entrySet()) {
            Profile profile;
            String value;
            Map.Entry profileWithId = _profileWithId;
            if (!activeProfiles.contains(profileWithId.getKey()) || (value = (profile = (Profile)profileWithId.getValue()).getProperties().getProperty(propertyName)) == null) continue;
            return value;
        }
        return null;
    }

    private List<String> getActiveProfiles(Settings settings) {
        if (settings == null) {
            return null;
        }
        List result = settings.getActiveProfiles();
        for (Profile profile : settings.getProfiles()) {
            if (!profile.getActivation().isActiveByDefault() || result.contains(profile.getId())) continue;
            result.add(profile.getId());
        }
        return result;
    }

    public boolean propertyExistsInSettings(String propertyName, Settings settings) {
        if (settings == null) {
            return false;
        }
        List<String> activeProfiles = this.getActiveProfiles(settings);
        for (Map.Entry _profileWithId : settings.getProfilesAsMap().entrySet()) {
            Profile profile;
            boolean result;
            Map.Entry profileWithId = _profileWithId;
            if (!activeProfiles.contains(profileWithId.getKey()) || !(result = (profile = (Profile)profileWithId.getValue()).getProperties().containsKey(propertyName))) continue;
            return result;
        }
        return false;
    }

    private String getPropertyValueInCommandLine(String propertyName, MavenSession session) {
        if (session == null) {
            return null;
        }
        return session.getRequest().getUserProperties().getProperty(propertyName);
    }

    public boolean propertyExistsInSettings(String propertyName) {
        return this.propertyExistsInSettings(propertyName, this.session.getSettings());
    }

    public boolean propertyExists(String propertyName) {
        return this.propertyExists(this.project, propertyName);
    }

    public boolean propertyExists(MavenProject mavenProject, String propertyName) {
        return mavenProject.getOriginalModel().getProperties().containsKey(propertyName) || mavenProject.getModel().getProperties().containsKey(propertyName) || this.session.getRequest().getUserProperties().containsKey(propertyName) || this.propertyExistsInSettings(propertyName, this.session.getSettings());
    }

    public String getPropertyValue(MavenProject mavenProject, String propertyName, boolean lookInSettingsProperties, boolean lookInCommandLine, boolean onlyInOriginalModel) {
        if (mavenProject == null) {
            return null;
        }
        String result = null;
        result = onlyInOriginalModel ? mavenProject.getOriginalModel().getProperties().getProperty(propertyName) : mavenProject.getModel().getProperties().getProperty(propertyName);
        if (lookInCommandLine && (result == null || result.isEmpty())) {
            result = this.getPropertyValueInCommandLine(propertyName, this.session);
        }
        if (lookInSettingsProperties && (result == null || result.isEmpty())) {
            result = this.getPropertyValueInSettings(propertyName, this.settings);
        }
        return result;
    }

    public String getPropertyValue(String propertyName, boolean onlyInOriginalModel) {
        return this.getPropertyValue(this.project, propertyName, true, true, onlyInOriginalModel);
    }

    public String getPropertyValue(String propertyName) {
        return this.getPropertyValue(propertyName, false);
    }

    public String getRootProjectProperty(MavenProject mavenProject, String propertyName) {
        return mavenProject == null ? "" : (mavenProject.getParent() == null ? this.getPropertyValue(mavenProject, propertyName, false, false, false) : this.getRootProjectProperty(mavenProject.getParent(), propertyName));
    }

    public String getRootProjectProperty(MavenProject mavenProject, String propertyName, boolean onlyInOriginalModel) {
        return mavenProject == null ? "" : (mavenProject.getParent() == null ? this.getPropertyValue(mavenProject, propertyName, false, false, onlyInOriginalModel) : this.getRootProjectProperty(mavenProject.getParent(), propertyName, onlyInOriginalModel));
    }

    public String getPropertyValue(String modelPropertyName, boolean propertyInRootProject, boolean onlyInOriginalModel, boolean lookInSettings) {
        String value = null;
        if (lookInSettings) {
            value = this.getPropertyValueInSettings(modelPropertyName, this.settings);
        }
        if (value == null) {
            value = propertyInRootProject ? this.getRootProjectProperty(this.project, modelPropertyName, onlyInOriginalModel) : this.getPropertyValue(modelPropertyName, onlyInOriginalModel);
        }
        return value;
    }

    public String replaceProperties(String string) {
        if (string == null) {
            return null;
        }
        Matcher m = mavenPropertyPattern.matcher(string);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String propertyName = m.group(1);
            String propertyValue = this.getPropertyValue(propertyName);
            if (propertyValue == null) continue;
            m.appendReplacement(sb, Matcher.quoteReplacement(propertyValue));
        }
        m.appendTail(sb);
        string = sb.toString();
        return string;
    }

    protected final MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    protected final MavenSession getSession() {
        return this.session;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    protected boolean isCurrentGoal(String goal) {
        return this.getSession().getRequest().getGoals().contains(goal);
    }

    private void checkBWProject() throws MojoExecutionException {
        if (this.projectDirectory == null) {
            this.projectNotFound();
        } else if (!this.projectDirectory.exists() || !this.projectDirectory.isDirectory()) {
            this.projectNotFound();
        }
    }

    private void projectNotFound() throws MojoExecutionException {
        throw new MojoExecutionException(BWPROJECT_NOTFOUND, (Exception)new FileNotFoundException());
    }

    protected String getBWEARName(Dependency bwEARDependency) {
        assert (bwEARDependency != null);
        return bwEARDependency.getArtifactId() + "-" + bwEARDependency.getVersion() + BWEAR_EXTENSION;
    }

    protected String getBWEARAlias(Dependency bwEARDependency) {
        assert (bwEARDependency != null);
        return bwEARDependency.getGroupId() + ":" + bwEARDependency.getArtifactId() + ":" + bwEARDependency.getVersion() + ":" + BWEAR_TYPE;
    }

    protected String getJarName(Dependency jarDependency, boolean replaceDot) {
        assert (jarDependency != null);
        String version = jarDependency.getVersion();
        if (replaceDot) {
            version = version.replace('.', '_');
        }
        return jarDependency.getArtifactId() + "-" + version + JAR_EXTENSION;
    }

    protected String getJarAlias(Dependency jarDependency, boolean replaceDot) {
        assert (jarDependency != null);
        String version = jarDependency.getVersion();
        if (replaceDot) {
            version = version.replace('.', '_');
        }
        return jarDependency.getGroupId() + ":" + jarDependency.getArtifactId() + ":" + version + ":" + JAR_TYPE;
    }

    protected String getProjlibName(Dependency projlibDependency) {
        assert (projlibDependency != null);
        return projlibDependency.getArtifactId() + "-" + projlibDependency.getVersion() + PROJLIB_EXTENSION;
    }

    protected String getProjlibAlias(Dependency projlibDependency) {
        assert (projlibDependency != null);
        return projlibDependency.getGroupId() + ":" + projlibDependency.getArtifactId() + ":" + projlibDependency.getVersion() + ":" + PROJLIB_TYPE;
    }

    protected String getDependencyPath(String dependencyName) {
        return this.buildLibDirectory.getAbsolutePath().replace('\\', '/') + "/" + dependencyName;
    }

    protected List<Dependency> readDependenciesFromFile(String resolvedFileName, String dependencyType) throws IOException {
        String strLine;
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        File resolvedFile = new File(resolvedFileName);
        if (!resolvedFile.exists()) {
            return dependencies;
        }
        FileInputStream fstream = new FileInputStream(resolvedFile);
        DataInputStream ds = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(ds));
        Pattern p = Pattern.compile("   (.*):(.*):" + dependencyType + ":(.*):(.*)");
        while ((strLine = br.readLine()) != null) {
            Matcher m = p.matcher(strLine);
            if (!m.matches()) continue;
            this.getLog().debug((CharSequence)m.group(0));
            String groupId = m.group(1);
            String artifactId = m.group(2);
            String version = m.group(3);
            String scope = m.group(4);
            Dependency dependency = new Dependency();
            dependency.setGroupId(groupId);
            dependency.setArtifactId(artifactId);
            dependency.setVersion(version);
            dependency.setType(dependencyType);
            dependency.setScope(scope);
            dependencies.add(dependency);
        }
        br.close();
        return dependencies;
    }

    protected List<Dependency> getDependencies(String dependencyType, boolean doIgnoreDependencies) throws IOException {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        List<Dependency> dependencies = this.readDependenciesFromFile(this.directory + "/resolved", dependencyType);
        for (Dependency dependency : dependencies) {
            if (doIgnoreDependencies && this.dependenciesIgnored.indexOf(dependency.getGroupId() + ':' + dependency.getArtifactId()) >= 0 || !dependency.getType().equals(dependencyType)) continue;
            result.add(dependency);
        }
        return result;
    }

    protected List<Dependency> getBWEARsDependencies() throws IOException {
        return this.getDependencies(BWEAR_TYPE, false);
    }

    protected List<Dependency> getProjlibsDependencies() throws IOException {
        return this.getDependencies(PROJLIB_TYPE, false);
    }

    protected List<Dependency> getJarDependencies() throws IOException {
        return this.getDependencies(JAR_TYPE, true);
    }

    private String formatAlias(String alias) {
        if (alias != null) {
            return alias.replace(":", "\\:");
        }
        return null;
    }

    public File getAliasesFile() {
        return new File(this.directory, ALIASES_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAliasesFile() throws IOException {
        File aliasesFile = this.getAliasesFile();
        FileWriter file = null;
        BufferedWriter buffer = null;
        PrintWriter aliasesFileOut = null;
        try {
            file = new FileWriter(aliasesFile);
            buffer = new BufferedWriter(file);
            aliasesFileOut = new PrintWriter(buffer);
            for (Dependency dependency : this.getJarDependencies()) {
                String jarName = this.getJarName(dependency, false);
                String jarAlias = this.formatAlias(this.getJarAlias(dependency, false));
                String jarPath = this.getDependencyPath(jarName);
                if (!new File(jarPath).exists()) continue;
                aliasesFileOut.println(TIBCO_ALIAS_PREFIX + jarAlias + "=" + jarPath);
            }
            for (Dependency dependency : this.getProjlibsDependencies()) {
                String projlibName = this.getProjlibName(dependency);
                String projlibAlias = this.formatAlias(this.getProjlibAlias(dependency));
                String projlibPath = this.getDependencyPath(projlibName);
                aliasesFileOut.println(TIBCO_ALIAS_PREFIX + projlibAlias + "=" + projlibPath);
            }
        }
        finally {
            aliasesFileOut.close();
            buffer.close();
            file.close();
        }
    }

    protected File getDesigner5Prefs() throws IOException {
        File homeTIBCO = new File(this.directory, TIBCO_HOME_DIR);
        if (!homeTIBCO.exists()) {
            homeTIBCO.mkdir();
        }
        File designer5Prefs = new File(homeTIBCO, DESIGNER5_PREFS);
        return designer5Prefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDesigner5Prefs() throws IOException {
        File designer5Prefs = this.getDesigner5Prefs();
        this.getLog().debug((CharSequence)("Designer5.prefs : " + System.getProperty("user.home") + "/" + TIBCO_HOME_DIR + "/" + DESIGNER5_PREFS));
        FileUtils.copyFile((File)new File(System.getProperty("user.home") + "/" + TIBCO_HOME_DIR + "/" + DESIGNER5_PREFS), (File)designer5Prefs);
        ReplaceRegExp replaceRegExp = new ReplaceRegExp();
        replaceRegExp.setFile(designer5Prefs);
        replaceRegExp.setMatch("filealias\\.pref\\.([0-9]*)=(.*)");
        replaceRegExp.setReplace("");
        replaceRegExp.setByLine(true);
        replaceRegExp.execute();
        FileWriter file = null;
        BufferedWriter buffer = null;
        PrintWriter designer5PrefsOut = null;
        try {
            file = new FileWriter(designer5Prefs, true);
            buffer = new BufferedWriter(file);
            designer5PrefsOut = new PrintWriter(buffer);
            designer5PrefsOut.println("");
            int i = 0;
            if (!this.hideLibraryResources) {
                for (Dependency dependency : this.getProjlibsDependencies()) {
                    String projlibName = this.getProjlibName(dependency);
                    String projlibAlias = this.getProjlibAlias(dependency);
                    String projlibPath = this.getDependencyPath(projlibName);
                    designer5PrefsOut.println(FILE_ALIAS_PREFIX + i++ + "=" + projlibAlias + "\\=" + projlibPath);
                }
            }
            for (Dependency dependency : this.getJarDependencies()) {
                String jarName = this.getJarName(dependency, false);
                String jarAlias = this.getJarAlias(dependency, false);
                String jarPath = this.getDependencyPath(jarName);
                designer5PrefsOut.println(FILE_ALIAS_PREFIX + i++ + "=" + jarAlias + "\\=" + jarPath);
            }
        }
        finally {
            designer5PrefsOut.close();
            buffer.close();
            file.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDesignTimeLibs() throws IOException {
        File designTimeLibs = new File(this.buildSrcDirectory + "/" + DTL_FILE_NAME);
        this.getLog().debug((CharSequence)(".designtimelibs : " + this.buildSrcDirectory + "/" + DTL_FILE_NAME));
        if (!designTimeLibs.exists()) {
            if (this.buildSrcDirectory.exists()) {
                designTimeLibs.createNewFile();
            } else {
                return;
            }
        }
        FileWriter file = null;
        BufferedWriter buffer = null;
        PrintWriter designTimeLibsOut = null;
        try {
            file = new FileWriter(designTimeLibs, false);
            buffer = new BufferedWriter(file);
            designTimeLibsOut = new PrintWriter(buffer);
            int i = this.getProjlibsDependencies().size();
            if (!this.hideLibraryResources) {
                for (Dependency dependency : this.getProjlibsDependencies()) {
                    String projlibAlias = this.getProjlibAlias(dependency);
                    designTimeLibsOut.println(--i + "=" + projlibAlias + "\\=");
                }
            }
        }
        finally {
            designTimeLibsOut.close();
            buffer.close();
            file.close();
        }
    }

    protected int launchTIBCOBinary(File binary, List<File> tras, ArrayList<String> arguments, File workingDir, String errorMsg, boolean fork, boolean synchronous) throws IOException, MojoExecutionException {
        Integer result = 0;
        if (tras == null) {
            String traPathFileName = binary.getAbsolutePath();
            traPathFileName = FilenameUtils.removeExtension((String)traPathFileName);
            traPathFileName = traPathFileName + ".tra";
            tras = new ArrayList<File>();
            tras.add(new File(traPathFileName));
        }
        HashMap<File, File> trasMap = new HashMap<File, File>();
        for (File file : tras) {
            File tmpTRAFile = new File(this.directory, file.getName());
            trasMap.put(file, tmpTRAFile);
            FileUtils.copyFile((File)file, (File)tmpTRAFile);
        }
        for (File file : trasMap.keySet()) {
            if (trasMap.containsKey(this.tibcoDesignerTRAPath) && (this.tibcoBuildEARUseDesignerTRA && file == this.tibcoBuildEARTRAPath || this.tibcoBuildLibraryUseDesignerTRA && file == this.tibcoBuildLibraryTRAPath) && tras.size() > 1) {
                ReplaceRegExp replaceRegExp = new ReplaceRegExp();
                replaceRegExp.setFile((File)trasMap.get(file));
                replaceRegExp.setMatch("tibco.include.tra (.*/designer.tra)");
                replaceRegExp.setReplace("tibco.include.tra " + ((File)trasMap.get(this.tibcoDesignerTRAPath)).toString().replace('\\', '/'));
                replaceRegExp.setByLine(true);
                replaceRegExp.execute();
            }
            if (file != this.tibcoBuildEARTRAPath && file != this.tibcoDesignerTRAPath && file != this.tibcoBWEngineTRAPath) continue;
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter((File)trasMap.get(file), true)));
            out.println("");
            out.println("java.property.user.home=" + this.directory.getAbsolutePath().replace("\\", "/"));
            out.close();
        }
        CommandLine cmdLine = new CommandLine(binary);
        for (String argument : arguments) {
            cmdLine.addArgument(argument);
        }
        this.getLog().debug((CharSequence)("launchTIBCOBinary command line : " + cmdLine.toString()));
        this.getLog().debug((CharSequence)("working dir : " + workingDir));
        DefaultExecutor defaultExecutor = new DefaultExecutor();
        defaultExecutor.setWorkingDirectory(workingDir);
        if (this.timeOut > 0) {
            ExecuteWatchdog watchdog = new ExecuteWatchdog((long)(this.timeOut * 1000));
            defaultExecutor.setWatchdog(watchdog);
        }
        defaultExecutor.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
        ByteArrayOutputStream stdOutAndErr = new ByteArrayOutputStream();
        defaultExecutor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)stdOutAndErr));
        if (fork) {
            CommandLauncher commandLauncher = CommandLauncherFactory.createVMLauncher();
            commandLauncher.exec(cmdLine, null, workingDir);
        } else {
            try {
                if (synchronous) {
                    result = defaultExecutor.execute(cmdLine);
                } else {
                    defaultExecutor.execute(cmdLine, (ExecuteResultHandler)new DefaultExecuteResultHandler());
                }
            }
            catch (ExecuteException e) {
                this.getLog().info((CharSequence)cmdLine.toString());
                this.getLog().info((CharSequence)stdOutAndErr.toString());
                this.getLog().info((CharSequence)result.toString());
                throw new MojoExecutionException(errorMsg, (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        return result;
    }

    protected void launchTIBCOBinary(File binary, List<File> tras, ArrayList<String> arguments, File workingDir, String errorMsg) throws IOException, MojoExecutionException {
        this.launchTIBCOBinary(binary, tras, arguments, workingDir, errorMsg, false, true);
    }

    protected void enableTestScope() {
        this.directory = this.testDirectory;
        this.buildSrcDirectory = this.testSrcDirectory;
        this.buildLibDirectory = this.testLibDirectory;
    }

    public void execute() throws MojoExecutionException {
        if (this.dependenciesIgnored == null) {
            this.dependenciesIgnored = new ArrayList();
        }
        if (!this.directory.exists()) {
            this.directory.mkdirs();
        }
        this.checkBWProject();
        try {
            this.copyAliasesFile();
            this.copyDesigner5Prefs();
            this.copyDesignTimeLibs();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

