/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven;

import fr.fastconnect.factory.tibco.bw.maven.AbstractBWMojo;
import fr.fastconnect.factory.tibco.bw.maven.source.POMManager;
import java.io.File;
import java.io.IOException;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="initialize", defaultPhase=LifecyclePhase.INITIALIZE)
public class InitializeMojo
extends AbstractBWMojo {
    protected static final String parentBasedirProperty = "parentProject.basedir";

    public static boolean hasSameGAV(Model m1, Model m2) {
        if (m1 == null || m2 == null) {
            return false;
        }
        return m1.getGroupId().equals(m2.getGroupId()) && m1.getArtifactId().equals(m2.getArtifactId()) && (m1.getVersion().equals(m2.getVersion()) || m1.getVersion() == null || m2.getVersion() == null) && m1.getPackaging().equals(m2.getPackaging());
    }

    private static boolean propertyExistsInModel(Model model, String propertyKey) {
        for (Object v : model.getProperties().values()) {
            String value = (String)v;
            if (!value.contains("${" + propertyKey + "}")) continue;
            return true;
        }
        return false;
    }

    private static boolean findParentPath(File path, Log logger) throws IOException, XmlPullParserException {
        File pomPath = new File(path + File.separator + "pom.xml");
        if (pomPath != null && pomPath.exists()) {
            logger.debug((CharSequence)("pomPath: " + pomPath.getAbsolutePath()));
            Model m = POMManager.getModelFromPOM(pomPath, logger);
            return InitializeMojo.propertyExistsInModel(m, parentBasedirProperty);
        }
        logger.debug((CharSequence)"find false");
        return false;
    }

    protected static File getParent(MavenProject project, Log logger) throws IOException, XmlPullParserException {
        File result = null;
        MavenProject parent = project.getParent();
        if (parent == null) {
            return result;
        }
        File parentPOM = parent.getFile();
        File parentBasedir = null;
        if (parentPOM != null && parentPOM.getParentFile() != null && parentPOM.getParentFile().exists() && parentPOM.getParentFile().isDirectory()) {
            parentBasedir = parentPOM.getParentFile();
        }
        logger.debug((CharSequence)("parentPOM: " + parentPOM.getAbsolutePath()));
        while (parentBasedir != null && parentBasedir.exists()) {
            logger.debug((CharSequence)("parentBasedir: " + parentBasedir.getAbsolutePath()));
            if (InitializeMojo.findParentPath(parentBasedir, logger)) {
                logger.debug((CharSequence)"parentFound");
                result = parentBasedir;
                break;
            }
            logger.debug((CharSequence)"parentNotFound");
            if (parent == null) continue;
            logger.debug((CharSequence)parent.getArtifactId());
            parentBasedir = parent.getParentFile();
            if (parentBasedir == null && parent.getParent() != null) {
                parentBasedir = parent.getParent().getFile();
            }
            if (parentBasedir != null) {
                logger.debug((CharSequence)parentBasedir.getAbsolutePath());
            }
            if (parentBasedir != null && parentBasedir.exists() && parentBasedir.isFile()) {
                parentBasedir = parentBasedir.getParentFile();
            }
            parent = parent.getParent();
        }
        return result;
    }

    private void setParentPath() throws IOException, XmlPullParserException {
        File parentPath = InitializeMojo.getParent(this.getProject(), this.getLog());
        if (parentPath != null) {
            this.getLog().debug((CharSequence)("parentProject.basedir: " + parentPath.getAbsolutePath()));
            this.getProject().getProperties().setProperty(parentBasedirProperty, parentPath.getAbsolutePath());
        }
    }

    @Override
    public void execute() throws MojoExecutionException {
        try {
            this.setParentPath();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

