/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.builtin;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class AbstractWrapperForBuiltinMojo<CustomResource extends Resource>
extends AbstractMojo {
    protected String groupId;
    protected String artifactId;
    protected String version;
    protected String goal;
    protected MavenProject project;
    protected MavenSession session;
    @Component(role=BuildPluginManager.class)
    protected BuildPluginManager pluginManager;
    protected Properties configuration;
    protected Properties resources;

    protected abstract String getGroupId();

    protected abstract String getArtifactId();

    protected abstract String getVersion();

    protected abstract String getGoal();

    protected abstract MavenProject getProject();

    protected abstract MavenSession getSession();

    protected abstract BuildPluginManager getPluginManager();

    protected abstract Properties getConfiguration();

    protected abstract List<CustomResource> getResources();

    protected MojoExecutor.ExecutionEnvironment getEnvironment() {
        return MojoExecutor.executionEnvironment((MavenProject)this.getProject(), (MavenSession)this.getSession(), (BuildPluginManager)this.getPluginManager());
    }

    protected List<MojoExecutor.Element> generateCustomElements(CustomResource resource) {
        return null;
    }

    private List<MojoExecutor.Element> generateResources() {
        List<CustomResource> resources = this.getResources();
        ArrayList<MojoExecutor.Element> resourcesElement = new ArrayList<MojoExecutor.Element>();
        if (resources != null) {
            this.getLog().debug((CharSequence)resources.toString());
            for (Resource resource : resources) {
                Object exclude2;
                ArrayList<MojoExecutor.Element> children = new ArrayList<MojoExecutor.Element>();
                children.add(MojoExecutor.element((String)"directory", (String)resource.getDirectory()));
                children.add(MojoExecutor.element((String)"filtering", (String)resource.getFiltering()));
                children.add(MojoExecutor.element((String)"targetPath", (String)resource.getTargetPath()));
                ArrayList<MojoExecutor.Element> excludes = new ArrayList<MojoExecutor.Element>();
                for (Object exclude2 : resource.getExcludes()) {
                    excludes.add(MojoExecutor.element((String)"exclude", (String)exclude2));
                }
                children.add(MojoExecutor.element((String)"excludes", (MojoExecutor.Element[])excludes.toArray(new MojoExecutor.Element[0])));
                ArrayList includes = new ArrayList();
                exclude2 = resource.getIncludes().iterator();
                while (exclude2.hasNext()) {
                    String include = (String)exclude2.next();
                    excludes.add(MojoExecutor.element((String)"include", (String)include));
                }
                children.add(MojoExecutor.element((String)"includes", (MojoExecutor.Element[])includes.toArray(new MojoExecutor.Element[0])));
                List<MojoExecutor.Element> customElements = this.generateCustomElements(resource);
                if (customElements != null) {
                    for (MojoExecutor.Element element : customElements) {
                        children.add(element);
                    }
                }
                resourcesElement.add(MojoExecutor.element((String)"resource", (MojoExecutor.Element[])children.toArray(new MojoExecutor.Element[0])));
            }
        }
        return resourcesElement;
    }

    private List<MojoExecutor.Element> generateConfiguration(Properties configuration) {
        List<MojoExecutor.Element> resources;
        ArrayList<MojoExecutor.Element> configurations = new ArrayList<MojoExecutor.Element>();
        if (configuration != null) {
            for (Object key : configuration.keySet()) {
                String value = configuration.get(key).toString();
                this.getLog().debug((CharSequence)value);
                if ("properties".equals(key) && value != null) {
                    this.getLog().debug((CharSequence)"key='properties'");
                    Pattern p = Pattern.compile("^\\$\\{(.*)\\}$");
                    Matcher matcherElement = p.matcher(value);
                    if (!matcherElement.matches()) continue;
                    this.getLog().debug((CharSequence)"matching properties to expand");
                    value = matcherElement.group(1);
                    String replacedValue = this.getProject().getProperties().getProperty(value);
                    if (replacedValue == null || replacedValue.isEmpty()) continue;
                    value = replacedValue;
                    this.getLog().debug((CharSequence)("properties_value: " + value));
                    Properties properties = new Properties();
                    try {
                        properties.load(new StringReader(value));
                        this.getLog().debug((CharSequence)properties.toString());
                    }
                    catch (IOException e) {
                        continue;
                    }
                    ArrayList<MojoExecutor.Element> children = new ArrayList<MojoExecutor.Element>();
                    for (Object o : properties.keySet()) {
                        String childKey = (String)o;
                        String childValue = properties.getProperty(childKey);
                        children.add(MojoExecutor.element((String)childKey, (String)childValue));
                    }
                    configurations.add(MojoExecutor.element((String)key.toString(), (MojoExecutor.Element[])children.toArray(new MojoExecutor.Element[0])));
                    continue;
                }
                configurations.add(MojoExecutor.element((String)key.toString(), (String)value));
            }
        }
        if ((resources = this.generateResources()) != null && !resources.isEmpty()) {
            configurations.add(MojoExecutor.element((String)"resources", (MojoExecutor.Element[])resources.toArray(new MojoExecutor.Element[0])));
        }
        return configurations;
    }

    public void execute() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)this.getGroupId()), (String)MojoExecutor.artifactId((String)this.getArtifactId()), (String)MojoExecutor.version((String)this.getVersion())), (String)MojoExecutor.goal((String)this.getGoal()), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])this.generateConfiguration(this.getConfiguration()).toArray(new MojoExecutor.Element[0])), (MojoExecutor.ExecutionEnvironment)this.getEnvironment());
    }
}

