/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.builtin;

import fr.fastconnect.factory.tibco.bw.maven.builtin.AbstractWrapperForBuiltinMojo;
import fr.fastconnect.factory.tibco.bw.maven.compile.ArchiveBuilder;
import fr.fastconnect.factory.tibco.bw.maven.source.POMManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.project.MavenProject;

public class CopyBWSourcesMojo
extends AbstractWrapperForBuiltinMojo<Resource> {
    protected String groupId;
    protected String artifactId;
    protected String version;
    protected String goal;
    protected MavenProject project;
    protected MavenSession session;
    @Component(role=BuildPluginManager.class)
    protected BuildPluginManager pluginManager;
    protected Properties configuration;
    protected List<Resource> resources;
    private PluginDescriptor pluginDescriptor;
    private String enterpriseArchiveName;
    private String processArchiveName;

    @Override
    protected String getGroupId() {
        return this.groupId;
    }

    @Override
    protected String getArtifactId() {
        return this.artifactId;
    }

    @Override
    protected String getVersion() {
        return this.version;
    }

    @Override
    protected String getGoal() {
        return this.goal;
    }

    @Override
    protected MavenProject getProject() {
        return this.project;
    }

    @Override
    protected MavenSession getSession() {
        return this.session;
    }

    @Override
    protected BuildPluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    protected Properties getConfiguration() {
        return this.configuration;
    }

    @Override
    protected List<Resource> getResources() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        if (this.resources != null) {
            result.addAll(this.resources);
        }
        if (this.isContainerEnabled(this.getProject())) {
            result.clear();
            this.getLog().debug((CharSequence)this.getProject().getProperties().toString());
            this.getLog().debug((CharSequence)this.getProject().getProperties().getProperty("project.build.directory.src"));
            File buildSrcDirectory = new File(this.getProject().getProperties().getProperty("project.build.directory.src"));
            buildSrcDirectory.mkdirs();
            String bwProjectArchiveBuilder = this.getProject().getProperties().getProperty("bw.project.archive.builder");
            File bwProjectArchiveMerged = new File(buildSrcDirectory.getAbsolutePath() + File.separator + bwProjectArchiveBuilder);
            this.getLog().debug((CharSequence)(".archive: " + bwProjectArchiveMerged.getAbsolutePath()));
            ArchiveBuilder mergedArchiveBuilder = new ArchiveBuilder();
            ArrayList<MavenProject> projectsToAggregate = new ArrayList<MavenProject>();
            MavenProject aggregator = this.getProject().getParent();
            List modules = aggregator.getModules();
            for (String module : modules) {
                this.getLog().debug((CharSequence)module);
                String pom = aggregator.getBasedir() + File.separator + module + File.separator + "pom.xml";
                File pomFile = new File(pom);
                try {
                    projectsToAggregate.add(new MavenProject(POMManager.getModelFromPOM(pomFile, this.getLog())));
                }
                catch (Exception e) {
                    this.getLog().debug((CharSequence)("Unable to add project from module: " + module));
                }
            }
            ArrayList projects = new ArrayList();
            projects.addAll(this.getSession().getProjects());
            Iterator it = projects.iterator();
            while (it.hasNext()) {
                MavenProject p = (MavenProject)it.next();
                if (this.isProjectToAggregate(p, projectsToAggregate)) continue;
                it.remove();
            }
            if (projects.size() > 0) {
                for (MavenProject p : projects) {
                    if (!p.getPackaging().equals("bw-ear") || this.isContainerEnabled(p)) continue;
                    String basedir = p.getBasedir().getAbsolutePath();
                    String bwProjectLocation = p.getProperties().getProperty("bw.project.location");
                    bwProjectArchiveBuilder = p.getProperties().getProperty("bw.project.archive.builder");
                    this.getLog().debug((CharSequence)basedir);
                    this.getLog().debug((CharSequence)bwProjectLocation);
                    File bwProjectArchive = new File(basedir + File.separator + bwProjectLocation + File.separator + bwProjectArchiveBuilder);
                    this.getLog().debug((CharSequence)bwProjectArchive.getAbsolutePath());
                    mergedArchiveBuilder.merge(bwProjectArchive);
                    File srcDirectory = new File(basedir + File.separator + bwProjectLocation);
                    result.add(this.addResource(srcDirectory));
                }
                mergedArchiveBuilder.setSharedArchiveAuthor(this.pluginDescriptor.getArtifactId());
                mergedArchiveBuilder.setEnterpriseArchiveAuthor(this.pluginDescriptor.getArtifactId());
                mergedArchiveBuilder.setEnterpriseArchiveFileLocationProperty(this.getProject().getArtifactId() + ".ear");
                mergedArchiveBuilder.setEnterpriseArchiveName(this.enterpriseArchiveName);
                mergedArchiveBuilder.setFirstProcessArchiveName(this.processArchiveName);
                mergedArchiveBuilder.removeDuplicateProcesses();
                mergedArchiveBuilder.save(bwProjectArchiveMerged);
            }
        }
        return result;
    }

    private boolean isProjectToAggregate(MavenProject project, List<MavenProject> projectsToAggregate) {
        if (project == null) {
            return false;
        }
        for (MavenProject p : projectsToAggregate) {
            if (!project.equals((Object)p)) continue;
            return true;
        }
        return false;
    }

    private Resource addResource(File srcDirectory) {
        Resource r = new Resource();
        r.setDirectory(srcDirectory.getAbsolutePath());
        r.setFiltering(true);
        r.addExclude("**/*TestSuite/");
        return r;
    }

    private boolean isContainerEnabled(MavenProject p) {
        if (p == null) {
            return false;
        }
        String isContainer = p.getProperties().getProperty("bw.container");
        return isContainer != null && isContainer.equals("true");
    }
}

