/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.bwengine;

import fr.fastconnect.factory.tibco.bw.maven.AbstractBWMojo;
import fr.fastconnect.factory.tibco.bw.maven.bwengine.ServiceAgentInEngine;
import fr.fastconnect.factory.tibco.bw.maven.exception.BinaryMissingException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractServiceEngineMojo
extends AbstractBWMojo {
    protected static final String BWENGINE_MISSING = "The BusinessWorks engine can't be found.";
    protected static final String BWENGINE_STARTING = "Starting BusinessWorks Engine";
    protected static final String BWENGINE_STOPPING = "Stopping BusinessWorks Engine";
    protected static final String BWENGINE_ERROR_STARTING = "Error while starting the BusinessWorks Engine";
    protected static final String BWENGINE_TIMEOUT_STARTING = "Timeout while starting the BusinessWorks Engine";
    @Parameter(property="bwengine.path", required=true)
    protected File tibcoBWEnginePath;
    @Parameter(property="bw.service.minPort", defaultValue="49152")
    protected int minPort;
    @Parameter(property="bw.service.maxPort", defaultValue="65535")
    protected int maxPort;
    protected ServiceAgentInEngine<?> serviceAgent;

    private void bwEngineNotFound() throws MojoExecutionException {
        throw new BinaryMissingException(BWENGINE_MISSING);
    }

    private void checkBWEngine() throws MojoExecutionException {
        if (this.tibcoBWEnginePath == null || !this.tibcoBWEnginePath.exists() || !this.tibcoBWEnginePath.isFile()) {
            this.bwEngineNotFound();
        }
    }

    public boolean isStarted() {
        return this.serviceAgent == null ? false : this.serviceAgent.isStarted();
    }

    public void stopEngine() {
        if (this.serviceAgent != null) {
            this.serviceAgent.stopEngine();
        }
    }

    public abstract void initServiceAgent() throws MojoExecutionException;

    public abstract void executeServiceMethods() throws MojoExecutionException;

    public abstract String getBWEnginePort();

    public abstract int getRetryInterval();

    public abstract String getServiceName();

    public abstract String getServiceFailureMessage();

    public abstract String getServiceTimeoutMessage();

    public int getTimeOut() {
        return this.timeOut;
    }

    private int getMaxRetry() {
        return this.getTimeOut() / this.getRetryInterval();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(int port, int minPort, int maxPort) {
        if (port < minPort || port > maxPort) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public Integer getFreePort(int minPort, int maxPort) {
        Random rand = new Random();
        int port = -1;
        while (!AbstractServiceEngineMojo.available(port = rand.nextInt(maxPort - minPort + 1) + minPort, minPort, maxPort)) {
        }
        return port;
    }

    public Integer getFreePort() {
        return this.getFreePort(this.minPort, this.maxPort);
    }

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        this.checkBWEngine();
        this.tibcoBWEnginePath = new File(this.tibcoBWEnginePath.getAbsolutePath());
        this.initServiceAgent();
        try {
            this.startEngine();
        }
        catch (IOException e) {
            throw new MojoExecutionException(this.getServiceFailureMessage(), (Exception)e);
        }
        for (int maxRetry = this.getMaxRetry(); !this.isStarted() && maxRetry > 0; --maxRetry) {
            try {
                Thread.sleep(this.getRetryInterval() * 1000);
                continue;
            }
            catch (InterruptedException iee) {
                iee.printStackTrace();
            }
        }
        if (!this.isStarted()) {
            throw new MojoExecutionException(this.getServiceTimeoutMessage());
        }
        this.getLog().debug((CharSequence)"Engine started");
        this.executeServiceMethods();
        this.getLog().info((CharSequence)BWENGINE_STOPPING);
        this.stopEngine();
    }

    private void startEngine() throws IOException, MojoExecutionException {
        Properties engineProperties = new Properties();
        engineProperties.setProperty("tibco.clientVar." + this.getServiceName() + "/HTTP-service-port", this.getBWEnginePort());
        engineProperties.setProperty("bw.plugin.jms.recoverOnStartupError", "true");
        File propertyFile = new File(this.directory, "bwengine.properties");
        propertyFile.createNewFile();
        FileOutputStream fos = new FileOutputStream(propertyFile);
        engineProperties.store(fos, null);
        fos.close();
        File aliasesFile = new File(this.directory, "aliases.properties");
        if (aliasesFile.exists()) {
            FileUtils.write((File)propertyFile, (CharSequence)FileUtils.readFileToString((File)aliasesFile), (boolean)true);
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-name");
        arguments.add(this.getServiceName() + " Web Service");
        arguments.add("-p");
        arguments.add(propertyFile.getAbsolutePath());
        arguments.add(this.getProjectToRunPath().getAbsolutePath());
        this.getLog().info((CharSequence)BWENGINE_STARTING);
        ArrayList<File> tras = new ArrayList<File>();
        tras.add(this.tibcoBWEngineTRAPath);
        this.launchTIBCOBinary(this.tibcoBWEnginePath, tras, arguments, this.directory, this.getServiceFailureMessage(), false, false);
    }

    protected abstract File getProjectToRunPath();
}

