/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.compile;

import fr.fastconnect.factory.tibco.bw.maven.compile.repository.ObjectFactory;
import fr.fastconnect.factory.tibco.bw.maven.compile.repository.Repository;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.collections.list.SetUniqueList;
import org.apache.commons.lang3.StringUtils;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ArchiveBuilder {
    private Repository repository;

    public ArchiveBuilder() {
        ObjectFactory of = new ObjectFactory();
        this.repository = of.createRepository();
    }

    public ArchiveBuilder(File f) {
        this();
        this.repository = this.load(f);
    }

    private ElementNSImpl getElement(ElementNSImpl parent, String elementName) {
        ElementNSImpl element;
        NodeList elements = parent.getElementsByTagName(elementName);
        if (elements != null) {
            element = (ElementNSImpl)elements.item(0);
        } else {
            element = (ElementNSImpl)new ElementImpl((CoreDocumentImpl)parent.getOwnerDocument(), elementName);
            parent.appendChild((Node)element);
        }
        return element;
    }

    public void removeDuplicateProcesses() {
        ElementNSImpl mergedEnterpriseArchive = (ElementNSImpl)this.repository.getAny().get(0);
        ElementNSImpl mergedProcessArchive = this.getElement(mergedEnterpriseArchive, "processArchive");
        ElementNSImpl mergedProcessProperty = this.getElement(mergedProcessArchive, "processProperty");
        String content = mergedProcessProperty.getTextContent();
        if (content != null && !content.isEmpty()) {
            SetUniqueList processes = SetUniqueList.decorate(new ArrayList());
            processes.addAll(Arrays.asList(content.split(",")));
            String contentWithoutDuplicate = StringUtils.join((Iterable)processes, (String)",");
            mergedProcessProperty.setTextContent(contentWithoutDuplicate);
        }
    }

    private Repository load(File f) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            Object o = jaxbUnmarshaller.unmarshal(f);
            return (Repository)o;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void save(File f) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Marshaller m = jaxbContext.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.marshal((Object)this.repository, f);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public ElementNSImpl getEnterpriseArchive() {
        ElementNSImpl e;
        List<Object> any = this.repository.getAny();
        if (any != null && any.size() > 0 && (e = (ElementNSImpl)any.get(0)).getLocalName().equals("enterpriseArchive")) {
            return e;
        }
        return null;
    }

    private ElementNSImpl getFirstProcessArchive() {
        NodeList processArchives;
        ElementNSImpl enterpriseArchive = this.getEnterpriseArchive();
        if (enterpriseArchive != null && (processArchives = enterpriseArchive.getElementsByTagName("processArchive")) != null && processArchives.getLength() > 0) {
            return (ElementNSImpl)enterpriseArchive.getElementsByTagName("processArchive").item(0);
        }
        return null;
    }

    public ElementNSImpl getSharedArchive() {
        NodeList sharedArchive;
        ElementNSImpl enterpriseArchive = this.getEnterpriseArchive();
        if (enterpriseArchive != null && (sharedArchive = enterpriseArchive.getElementsByTagName("sharedArchive")) != null && sharedArchive.getLength() > 0) {
            return (ElementNSImpl)enterpriseArchive.getElementsByTagName("sharedArchive").item(0);
        }
        return null;
    }

    public void setSharedArchiveAuthor(String textContent) {
        this.setProperty(this.getSharedArchive(), "authorProperty", textContent);
    }

    public void setEnterpriseArchiveAuthor(String textContent) {
        this.setEnterpriseArchiveProperty("authorProperty", textContent);
    }

    public void setEnterpriseArchiveName(String textContent) {
        this.setEnterpriseArchiveProperty("name", textContent);
    }

    public void setEnterpriseArchiveFileLocationProperty(String textContent) {
        this.setEnterpriseArchiveProperty("fileLocationProperty", textContent);
    }

    public void setEnterpriseArchiveVersionProperty(String textContent) {
        this.setEnterpriseArchiveProperty("versionProperty", textContent);
    }

    protected void setEnterpriseArchiveProperty(String propertyName, String textContent) {
        this.setProperty(this.getEnterpriseArchive(), propertyName, textContent);
    }

    public void setFirstProcessArchiveName(String textContent) {
        this.setAttribute(this.getFirstProcessArchive(), "name", textContent);
    }

    protected void setAttribute(ElementNSImpl element, String attributeName, String textContent) {
        Attr attribute;
        if (element != null && (attribute = element.getAttributeNode(attributeName)) != null) {
            attribute.setTextContent(textContent);
        }
    }

    protected void setProperty(ElementNSImpl element, String propertyName, String textContent) {
        if (element != null) {
            Node parentNode;
            NodeList properties = element.getElementsByTagName(propertyName);
            ElementNSImpl property = null;
            for (int i = 0; i < properties.getLength() && (parentNode = (property = (ElementNSImpl)properties.item(i)).getParentNode()) != element; ++i) {
            }
            if (property != null) {
                property.setTextContent(textContent);
            }
        }
    }

    public void merge(File archiveFile) {
        ArchiveBuilder archiveBuilder = new ArchiveBuilder(archiveFile);
        this.merge(archiveBuilder);
    }

    public void merge(ArchiveBuilder archiveBuilder) {
        ElementNSImpl mergedEnterpriseArchive = this.getEnterpriseArchive();
        ElementNSImpl enterpriseArchive = archiveBuilder.getEnterpriseArchive();
        if (mergedEnterpriseArchive == null) {
            this.repository.getAny().add(enterpriseArchive);
            return;
        }
        List<Object> elements = archiveBuilder.repository.getAny();
        for (ElementNSImpl elementNSImpl : elements) {
            if (!elementNSImpl.getLocalName().equals("enterpriseArchive")) continue;
            ElementNSImpl mergedProcessArchive = this.getElement(mergedEnterpriseArchive, "processArchive");
            ElementNSImpl mergedProcessProperty = this.getElement(mergedProcessArchive, "processProperty");
            ElementNSImpl nodes = (ElementNSImpl)elementNSImpl.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                ElementNSImpl n;
                Node o = nodes.item(i);
                if (!o.getClass().getName().equals("org.apache.xerces.dom.ElementNSImpl") || (n = (ElementNSImpl)o) == null || !"processArchive".equals(n.getLocalName())) continue;
                ElementNSImpl processArchive = n;
                ElementNSImpl processProperty = (ElementNSImpl)processArchive.getElementsByTagName("processProperty").item(0);
                String newContent = processProperty.getTextContent();
                String oldContent = mergedProcessProperty.getTextContent();
                if (newContent == null || newContent.isEmpty()) continue;
                if (oldContent != null && !oldContent.isEmpty()) {
                    newContent = oldContent + "," + newContent;
                }
                mergedProcessProperty.setTextContent(newContent);
            }
        }
    }
}

