/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.compile;

import fr.fastconnect.factory.tibco.bw.maven.AbstractBWArtifactMojo;
import fr.fastconnect.factory.tibco.bw.maven.exception.BinaryMissingException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="compile-bw-ear", defaultPhase=LifecyclePhase.COMPILE)
public class CompileEARMojo
extends AbstractBWArtifactMojo {
    protected static final String BUILDEAR_BINARY_NOTFOUND = "The TIBCO 'buildear' binary can't be found.";
    protected static final String BUILD_EAR_FAILED = "The build of the EAR file has failed.";
    protected static final String COPY_EAR_FAILED = "Unable to copy the EAR to the package directory.";
    protected static final String BUILDING_EAR = "Building the EAR...";
    protected static final String EAR_LOCATION = "Output EAR location: ";
    @Parameter(property="bw.project.archive.builder", required=true)
    protected String archiveFile;
    @Parameter(property="buildear.path", required=true)
    protected File tibcoBuildEARPath;
    @Parameter(property="bw.clean.projlib.defaultVars")
    private boolean cleanDefaultVars;
    @Component
    private MavenProjectHelper projectHelper;

    private void checkBuildEAR() throws MojoExecutionException {
        if (this.tibcoBuildEARPath == null || !this.tibcoBuildEARPath.exists() || !this.tibcoBuildEARPath.isFile()) {
            this.tibcoBuildEARPathNotFound();
        }
    }

    private void tibcoBuildEARPathNotFound() throws MojoExecutionException {
        throw new BinaryMissingException(BUILDEAR_BINARY_NOTFOUND);
    }

    @Override
    protected String getArtifactFileExtension() {
        return ".ear";
    }

    private void buildEAR(File outputFile) throws MojoExecutionException, IOException {
        this.checkBuildEAR();
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-ear");
        arguments.add(this.archiveFile);
        arguments.add("-p");
        arguments.add(this.buildSrcDirectory.getAbsolutePath());
        arguments.add("-o");
        arguments.add(outputFile.getAbsolutePath());
        arguments.add("-x");
        arguments.add("-v");
        File aliasesFile = new File(this.directory, "aliases.properties");
        if (aliasesFile.exists()) {
            arguments.add("-a");
            arguments.add(aliasesFile.getAbsolutePath());
        }
        this.getLog().info((CharSequence)BUILDING_EAR);
        ArrayList<File> tras = new ArrayList<File>();
        tras.add(this.tibcoBuildEARTRAPath);
        if (this.tibcoBuildEARUseDesignerTRA) {
            tras.add(this.tibcoDesignerTRAPath);
        }
        this.launchTIBCOBinary(this.tibcoBuildEARPath, tras, arguments, this.directory, BUILD_EAR_FAILED);
    }

    private void cleanDefaultVars() throws IOException {
        File varsDirectory = new File(this.buildSrcDirectory, "defaultVars");
        this.cleanVarsDirectory(varsDirectory, this.getProjlibsDependencies());
    }

    protected void cleanVarsDirectory(File varsDirectory, List<Dependency> projlibList) {
        File[] listFiles = varsDirectory.listFiles();
        ArrayList<String> projlibNames = new ArrayList<String>();
        for (Dependency dependency : projlibList) {
            projlibNames.add(dependency.getArtifactId());
        }
        for (File dir : listFiles) {
            if (!projlibNames.contains(dir.getName()) || !dir.isDirectory()) continue;
            for (File defaultVarsFile : dir.listFiles()) {
                this.cleanDirectory(defaultVarsFile);
            }
            dir.delete();
        }
    }

    protected boolean cleanDirectory(File directory) {
        if (directory.isDirectory() && directory.listFiles().length != 0) {
            for (File file : directory.listFiles()) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
        return directory.delete();
    }

    private void doCleanDefaultVars() throws MojoExecutionException {
        if (this.cleanDefaultVars) {
            try {
                this.cleanDefaultVars();
            }
            catch (IOException e) {
                throw new MojoExecutionException(BUILD_EAR_FAILED, (Exception)e);
            }
        }
    }

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skipCompile.booleanValue() || this.skipEARCompile.booleanValue()) {
            this.getLog().info((CharSequence)"Skipping.");
            File outputFile = this.getOutputFile();
            if (outputFile != null && !outputFile.exists() && this.touchEARIfSkipped.booleanValue()) {
                try {
                    outputFile.getParentFile().mkdirs();
                    outputFile.createNewFile();
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
                }
            }
            if (outputFile != null && outputFile.exists()) {
                this.attachArtifact(outputFile);
            } else {
                this.getLog().warn((CharSequence)"Could not attach artifact.");
            }
            return;
        }
        if (this.isCurrentGoal("bw:launch-designer")) {
            return;
        }
        this.doCleanDefaultVars();
        super.execute();
        this.checkOutputDirectory();
        File outputFile = this.getOutputFile();
        this.getLog().debug((CharSequence)(EAR_LOCATION + outputFile.getAbsolutePath()));
        try {
            this.buildEAR(outputFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException(BUILD_EAR_FAILED, (Exception)e);
        }
        try {
            if (!this.packageDirectory.exists()) {
                this.packageDirectory.mkdirs();
            }
            FileUtils.copyFile((File)outputFile, (File)new File(this.packageDirectory + File.separator + outputFile.getName()));
        }
        catch (IOException e) {
            throw new MojoExecutionException(COPY_EAR_FAILED, (Exception)e);
        }
        this.attachArtifact(outputFile);
    }

    private void attachArtifact(File outputFile) {
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.getProject(), "bw-ear", this.classifier, outputFile);
        } else {
            this.getProject().getArtifact().setFile(outputFile);
        }
    }
}

