/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.compile;

import fr.fastconnect.factory.tibco.bw.maven.AbstractBWArtifactMojo;
import fr.fastconnect.factory.tibco.bw.maven.exception.BinaryMissingException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="compile-projlib", defaultPhase=LifecyclePhase.COMPILE)
public class CompileProjlibMojo
extends AbstractBWArtifactMojo {
    protected static final String TIBCO_DESIGNER_BINARY_NOTFOUND = "The TIBCO Designer binary can't be found.";
    protected static final String BUILD_PROJLIB_FAILED = "The build of the Projlib file has failed.";
    protected static final String BUILDING_PROJLIB = "Building the Projlib...";
    @Parameter(property="bw.project.library.builder", required=true)
    private String libBuilder;
    @Parameter(property="buildlibrary.path", required=true)
    private File tibcoBuildLibraryPath;

    private void checkDesignerBuildLibrary() throws MojoExecutionException {
        if (this.tibcoBuildLibraryPath == null || !this.tibcoBuildLibraryPath.exists() || !this.tibcoBuildLibraryPath.isFile()) {
            this.designerBuildLibraryPathNotFound();
        }
    }

    private void designerBuildLibraryPathNotFound() throws MojoExecutionException {
        throw new BinaryMissingException(TIBCO_DESIGNER_BINARY_NOTFOUND);
    }

    @Override
    protected String getArtifactFileExtension() {
        return ".projlib";
    }

    private void buildProjlib(File outputFile) throws MojoExecutionException, IOException {
        this.checkDesignerBuildLibrary();
        assert (outputFile != null);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-lib");
        arguments.add(this.libBuilder);
        arguments.add("-p");
        arguments.add(this.buildSrcDirectory.getAbsolutePath());
        arguments.add("-o");
        arguments.add(outputFile.getAbsolutePath());
        arguments.add("-x");
        if (!this.hideLibraryResources) {
            arguments.add("-v");
        }
        this.getLog().info((CharSequence)BUILDING_PROJLIB);
        ArrayList<File> tras = new ArrayList<File>();
        tras.add(this.tibcoBuildLibraryTRAPath);
        if (this.tibcoBuildLibraryUseDesignerTRA) {
            tras.add(this.tibcoDesignerTRAPath);
        }
        this.launchTIBCOBinary(this.tibcoBuildLibraryPath, tras, arguments, this.directory, BUILD_PROJLIB_FAILED);
    }

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skipCompile.booleanValue() || this.skipProjlibCompile.booleanValue()) {
            this.getLog().info((CharSequence)"Skipping.");
            File outputFile = this.getOutputFile();
            if (outputFile != null && !outputFile.exists() && this.touchProjlibIfSkipped.booleanValue()) {
                try {
                    outputFile.getParentFile().mkdirs();
                    outputFile.createNewFile();
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
                }
            }
            if (outputFile != null && outputFile.exists()) {
                this.attachArtifact(outputFile);
            } else {
                this.getLog().warn((CharSequence)"Could not attach artifact.");
            }
            return;
        }
        if (this.isCurrentGoal("bw:launch-designer")) {
            return;
        }
        super.execute();
        File outputFile = this.getOutputFile();
        try {
            this.buildProjlib(outputFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException(BUILD_PROJLIB_FAILED, (Exception)e);
        }
        this.attachArtifact(outputFile);
    }

    private void attachArtifact(File outputFile) {
        this.getProject().getArtifact().setFile(outputFile);
    }
}

