/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.compile;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.sl.IOPoolLocator;
import fr.fastconnect.factory.tibco.bw.maven.AbstractBWArtifactMojo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.truezip.Fileset;
import org.codehaus.mojo.truezip.TrueZipFileSet;
import org.codehaus.mojo.truezip.internal.DefaultTrueZip;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

@Mojo(name="include-dependencies-in-bw-ear", defaultPhase=LifecyclePhase.COMPILE)
public class IncludeDependenciesInEARMojo
extends AbstractBWArtifactMojo {
    @Parameter(property="includeTransitiveJARsInEAR", defaultValue="true")
    public Boolean includeTransitiveJARsInEAR;
    @Parameter(property="removeVersionFromFileNames", defaultValue="false")
    public Boolean removeVersionFromFileNames;
    private DefaultTrueZip truezip;

    @Override
    protected String getArtifactFileExtension() {
        return ".ear";
    }

    private void copyRuntimeJARsInEAR(File ear) throws IOException, JDOMException {
        Fileset fileSet = new Fileset();
        fileSet.setDirectory(this.buildLibDirectory.getAbsolutePath());
        for (Dependency dependency : this.getJarDependencies()) {
            String jarName = this.getJarName(dependency, false);
            fileSet.addInclude(jarName);
        }
        String ouptutDirectory = ear.getAbsolutePath() + File.separator + "lib.zip" + File.separator + "WEB-INF" + File.separator + "lib";
        fileSet.setOutputDirectory(ouptutDirectory);
        if (fileSet.getIncludes() != null && !fileSet.getIncludes().isEmpty()) {
            this.truezip.copy((TrueZipFileSet)fileSet);
        }
        this.truezip.sync();
        if (this.removeVersionFromFileNames.booleanValue()) {
            this.removeVersionFromFileNames(ouptutDirectory, ear);
            this.truezip.sync();
        }
    }

    private void removeVersionFromFileNames(String ouptutDirectory, File ear) throws IOException, JDOMException {
        for (Dependency dependency : this.getJarDependencies()) {
            String includeOrigin;
            Pattern p = Pattern.compile("(.*)-" + dependency.getVersion() + ".jar");
            Matcher m = p.matcher(includeOrigin = this.getJarName(dependency, false));
            if (!m.matches()) continue;
            String includeDestination = m.group(1) + ".jar";
            this.truezip.moveFile(new TFile(ouptutDirectory + File.separator + includeOrigin), new TFile(ouptutDirectory + File.separator + includeDestination));
            this.updateAlias(includeOrigin, includeDestination, ear);
        }
        this.truezip.sync();
    }

    private void updateAlias(String includeOrigin, String includeDestination, File ear) throws JDOMException, IOException, JDOMException {
        TFile xmlTIBCO = new TFile(ear.getAbsolutePath() + File.separator + "TIBCO.xml");
        String tempPath = ear.getParentFile().getAbsolutePath() + File.separator + "TIBCO.xml";
        TFile xmlTIBCOTemp = new TFile(tempPath);
        this.truezip.copyFile(xmlTIBCO, xmlTIBCOTemp);
        File xmlTIBCOFile = new File(tempPath);
        SAXBuilder sxb = new SAXBuilder();
        Document document = sxb.build(xmlTIBCOFile);
        XPath xpa = XPath.newInstance((String)("//dd:NameValuePairs/dd:NameValuePair[starts-with(dd:name, 'tibco.alias') and dd:value='" + includeOrigin + "']/dd:value"));
        xpa.addNamespace("dd", "http://www.tibco.com/xmlns/dd");
        Element singleNode = (Element)xpa.selectSingleNode((Object)document);
        if (singleNode != null) {
            singleNode.setText(includeDestination);
            XMLOutputter xmlOutput = new XMLOutputter();
            xmlOutput.setFormat(Format.getPrettyFormat().setIndent("    "));
            xmlOutput.output(document, (Writer)new FileWriter(xmlTIBCOFile));
            this.truezip.copyFile(xmlTIBCOTemp, xmlTIBCO);
        }
        this.updateAliasInPARs(includeOrigin, includeDestination, ear);
    }

    private void updateAliasInPARs(String includeOrigin, String includeDestination, File ear) throws IOException, JDOMException {
        TrueZipFileSet pars = new TrueZipFileSet();
        pars.setDirectory(ear.getAbsolutePath());
        pars.addInclude("*.par");
        List parsXML = this.truezip.list(pars);
        for (TFile parXML : parsXML) {
            TFile xmlTIBCO = new TFile((File)parXML, "TIBCO.xml");
            String tempPath = ear.getParentFile().getAbsolutePath() + File.separator + "TIBCO.xml";
            TFile xmlTIBCOTemp = new TFile(tempPath);
            this.truezip.copyFile(xmlTIBCO, xmlTIBCOTemp);
            File xmlTIBCOFile = new File(tempPath);
            SAXBuilder sxb = new SAXBuilder();
            Document document = sxb.build(xmlTIBCOFile);
            XPath xpa = XPath.newInstance((String)"//dd:NameValuePairs/dd:NameValuePair[dd:name='EXTERNAL_JAR_DEPENDENCY']/dd:value");
            xpa.addNamespace("dd", "http://www.tibco.com/xmlns/dd");
            Element singleNode = (Element)xpa.selectSingleNode((Object)document);
            if (singleNode == null) continue;
            String value = singleNode.getText().replace(includeOrigin, includeDestination);
            singleNode.setText(value);
            XMLOutputter xmlOutput = new XMLOutputter();
            xmlOutput.setFormat(Format.getPrettyFormat().setIndent("    "));
            xmlOutput.output(document, (Writer)new FileWriter(xmlTIBCOFile));
            this.truezip.copyFile(xmlTIBCOTemp, xmlTIBCO);
        }
    }

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skipCompile.booleanValue() || this.skipEARCompile.booleanValue()) {
            this.getLog().info((CharSequence)"Skipping.");
            return;
        }
        if (this.isCurrentGoal("bw:launch-designer") || !this.includeTransitiveJARsInEAR.booleanValue()) {
            return;
        }
        super.execute();
        File ear = this.getProject().getArtifact().getFile();
        if (ear == null) {
            ear = this.getOutputFile();
        }
        this.getLog().debug((CharSequence)("Using EAR : " + ear.getAbsolutePath()));
        TConfig.get().setArchiveDetector(new TArchiveDetector((FsDriverProvider)TArchiveDetector.NULL, (Object[][])new Object[][]{{"zip|kar|par|ear", new ZipDriver((IOPoolProvider)IOPoolLocator.SINGLETON)}}));
        this.truezip = new DefaultTrueZip();
        try {
            this.copyRuntimeJARsInEAR(ear);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (JDOMException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

