/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.compile;

import fr.fastconnect.factory.tibco.bw.maven.AbstractBWArtifactMojo;
import fr.fastconnect.factory.tibco.bw.maven.source.AbstractProjectsListMojo;
import fr.fastconnect.factory.tibco.bw.maven.source.alias.RepositoryModel;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="update-alias-lib", defaultPhase=LifecyclePhase.COMPILE)
public class UpdateAliasesLibsMojo
extends AbstractBWArtifactMojo {
    protected static final String SRC_NOT_SET = "Source directory is not set. Modification of '.aliaslib' file might fail.";
    @Parameter(property="includeTransitiveJARsInEAR", defaultValue="true")
    public Boolean includeTransitiveJARsInEAR;
    @Parameter(required=false)
    public List<File> customAliasLibDirectories;
    @Parameter(required=false, defaultValue="true")
    public Boolean keepOriginalAliasLib;
    private List<File> aliaslibFiles;
    private List<Dependency> jarDependencies;

    @Override
    protected String getArtifactFileExtension() {
        return ".ear";
    }

    private List<File> initFiles() throws IOException {
        FileSet restriction = new FileSet();
        File directory = this.buildSrcDirectory;
        if (directory == null) {
            directory = new File(".");
            this.getLog().warn((CharSequence)SRC_NOT_SET);
        }
        this.getLog().debug((CharSequence)directory.getAbsolutePath());
        restriction.setDirectory(directory.getAbsolutePath());
        restriction.addInclude("**/*.aliaslib");
        List<File> result = AbstractProjectsListMojo.toFileList(restriction);
        if (this.customAliasLibDirectories != null && !this.customAliasLibDirectories.isEmpty()) {
            for (File customDirectory : this.customAliasLibDirectories) {
                this.getLog().debug((CharSequence)("Looking for '.aliaslib' files in custom directory: " + customDirectory));
                FileSet customRestriction = new FileSet();
                customRestriction.setDirectory(customDirectory.getAbsolutePath());
                customRestriction.addInclude("**/*.aliaslib");
                result.addAll(AbstractProjectsListMojo.toFileList(customRestriction));
            }
        }
        this.getLog().debug((CharSequence)("List of '.aliaslib' files to update: " + result));
        return result;
    }

    private void addAlias(ArrayList<HashMap<String, Object>> list, String aliasName) {
        for (HashMap<String, Object> h : list) {
            String name = (String)h.get("name");
            if (name == null || !name.equals(aliasName)) continue;
            return;
        }
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("isClasspathFile", Boolean.TRUE);
        h.put("name", aliasName);
        h.put("includeInDeployment", Boolean.TRUE);
        list.add(h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<HashMap<String, Object>> readXMLBean(RepositoryModel repositoryModel, File f) throws JAXBException, UnsupportedEncodingException {
        String xmlBean = repositoryModel.getRepository().getName().getFILEALIASESLIST();
        XMLDecoder d = new XMLDecoder(new ByteArrayInputStream(xmlBean.getBytes(this.sourceEncoding)));
        ArrayList result = null;
        try {
            result = (ArrayList)d.readObject();
        }
        finally {
            d.close();
        }
        return result;
    }

    private void writeXMLBean(RepositoryModel repositoryModel, File f, ArrayList<HashMap<String, Object>> aliases) throws JAXBException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XMLEncoder e = new XMLEncoder(os);
        e.writeObject(aliases);
        e.close();
        String xmlBean = os.toString(this.sourceEncoding);
        os.close();
        repositoryModel.getRepository().getName().setFILEALIASESLIST(xmlBean);
        repositoryModel.save();
    }

    public void processFile(File f) throws MojoExecutionException {
        try {
            RepositoryModel repositoryModel = new RepositoryModel(f);
            ArrayList<HashMap<String, Object>> aliases = this.readXMLBean(repositoryModel, f);
            if (!this.keepOriginalAliasLib.booleanValue()) {
                aliases.clear();
            }
            for (Dependency dependency : this.jarDependencies) {
                this.addAlias(aliases, this.getJarAlias(dependency, false));
            }
            this.writeXMLBean(repositoryModel, f, aliases);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skipCompile.booleanValue() || this.skipEARCompile.booleanValue() || (this.isCurrentGoal("bw:launch-designer") || !this.includeTransitiveJARsInEAR.booleanValue()) && (this.customAliasLibDirectories == null || this.customAliasLibDirectories.isEmpty())) {
            this.getLog().info((CharSequence)"Skipping.");
            return;
        }
        super.execute();
        try {
            this.jarDependencies = this.getJarDependencies();
            this.aliaslibFiles = this.initFiles();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        for (File f : this.aliaslibFiles) {
            this.processFile(f);
        }
    }
}

