/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.deployment;

import fr.fastconnect.factory.tibco.bw.maven.deployment.AbstractBWDeployMojo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="deploy-bw", defaultPhase=LifecyclePhase.DEPLOY)
@Execute(goal="deploy-bw", lifecycle="deploy")
public class DeployEARMojo
extends AbstractBWDeployMojo {
    protected static final String DEPLOY_EAR_FAILED = "The deployment of the application failed.";
    protected static final String DEPLOYING_APPLICATION = "Deploying application to ";
    protected static final String DEPLOYING_ON_DOMAIN = " on domain ";
    protected static final String USING_EAR = "Using EAR : ";
    protected static final String USING_XML = "Using XML : ";
    @Parameter
    private boolean redeploy;
    @Parameter(property="deploy.nostart", defaultValue="false")
    private boolean noStart;
    @Parameter(property="deploy.nostop", defaultValue="false")
    private boolean noStop;
    @Parameter(property="deploy.serialize", defaultValue="true")
    private boolean serialize;
    @Parameter
    private File deployConfigXML;

    private void deployEAR() throws MojoExecutionException, IOException {
        this.checkAppManage();
        File ear = this.getOutputFile();
        this.getLog().info((CharSequence)("Deploying application to '" + this.deployedProjectName + "'" + DEPLOYING_ON_DOMAIN + "'" + this.domainName + "'"));
        this.getLog().info((CharSequence)(USING_EAR + ear.getAbsolutePath()));
        this.getLog().info((CharSequence)(USING_XML + this.deploymentDescriptorFinal.getAbsolutePath()));
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-deploy");
        arguments.add("-ear");
        arguments.add(ear.getAbsolutePath());
        arguments.add("-deployConfig");
        arguments.add(this.deploymentDescriptorFinal.getAbsolutePath());
        arguments.add("-app");
        arguments.add(this.deployedProjectName);
        arguments.add("-domain");
        arguments.add(this.domainName);
        arguments.add("-user");
        arguments.add(this.domainUsername);
        arguments.add("-pw");
        arguments.add(this.domainPassword);
        if (this.serialize) {
            arguments.add("-serialize");
        }
        if (this.noStart) {
            arguments.add("-nostart");
        }
        if (this.noStop) {
            arguments.add("-nostop");
        }
        arguments.add("-force");
        ArrayList<File> tras = new ArrayList<File>();
        tras.add(this.tibcoAppManageTRAPath);
        this.launchTIBCOBinary(this.tibcoAppManagePath, tras, arguments, this.directory, DEPLOY_EAR_FAILED);
    }

    @Override
    public void execute() throws MojoExecutionException {
        if (super.skip()) {
            return;
        }
        try {
            this.deployEAR();
        }
        catch (IOException e) {
            throw new MojoExecutionException(DEPLOY_EAR_FAILED, (Exception)e);
        }
    }
}

