/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.deployment;

import fr.fastconnect.factory.tibco.bw.maven.deployment.AbstractBWDeployMojo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="extract-xml-from-domain", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class ExtractXMLFromDomainMojo
extends AbstractBWDeployMojo {
    protected static final String CREATING_XML_FROM_DOMAIN = "Extracting the XML Deployment Descriptor from domain ";
    protected static final String CREATE_XML_FROM_DOMAIN_SUCCESS = "Successfully extracted the XML Deployment Descriptor to ";
    protected static final String CREATE_XML_FROM_DOMAIN_FAILED = "The extraction of the XML Deployment Descriptor file from the deployed application file has failed.";

    private void createXML() throws MojoExecutionException, IOException {
        this.checkAppManage();
        String xmlOutputFile = this.deploymentDescriptor.getPath();
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-export");
        arguments.add("-app");
        arguments.add(this.deployedProjectName);
        arguments.add("-domain");
        arguments.add(this.domainName);
        arguments.add("-user");
        arguments.add(this.domainUsername);
        arguments.add("-pw");
        arguments.add(this.domainPassword);
        arguments.add("-out");
        arguments.add(xmlOutputFile);
        ArrayList<File> tras = new ArrayList<File>();
        tras.add(this.tibcoAppManageTRAPath);
        this.launchTIBCOBinary(this.tibcoAppManagePath, tras, arguments, this.directory, CREATE_XML_FROM_DOMAIN_FAILED);
    }

    @Override
    public void execute() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Extracting the XML Deployment Descriptor from domain '" + this.domainName + "'"));
            this.createXML();
            this.getLog().info((CharSequence)("Successfully extracted the XML Deployment Descriptor to  '" + this.deploymentDescriptor + "'"));
        }
        catch (IOException e) {
            throw new MojoExecutionException(CREATE_XML_FROM_DOMAIN_FAILED, (Exception)e);
        }
    }
}

