/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.deployment;

import COM.TIBCO.hawk.console.hawkeye.ConsoleInitializationException;
import COM.TIBCO.hawk.talon.MicroAgentData;
import COM.TIBCO.hawk.talon.MicroAgentException;
import COM.TIBCO.hawk.talon.Subscription;
import fr.fastconnect.factory.tibco.bw.maven.deployment.AbstractBWDeployMojo;
import fr.fastconnect.factory.tibco.bw.maven.hawk.DefaultSubscriptionHandler;
import fr.fastconnect.factory.tibco.bw.maven.hawk.MethodSubscriber;
import fr.fastconnect.factory.tibco.bw.maven.hawk.MicroAgent;
import fr.fastconnect.factory.tibco.bw.maven.packaging.ApplicationManagement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="start-bw", defaultPhase=LifecyclePhase.DEPLOY)
public class StartEARMojo
extends AbstractBWDeployMojo {
    protected static final String STARTING_INSTANCES_FAILED = "Some instances failed to be started.";
    protected static final String STARTING_INSTANCES = "Starting instances of the application...";
    protected static final String WAITING_FOR_INSTANCES = "Waiting for instances to be started...";
    protected static final String SUBSCRIBING_TO_HAWK_METHODS = "Subscribing to Hawk methods:";
    protected static final String ALL_INSTANCES_STARTED = "All instances successfully started.";
    protected static final String SOME_INSTANCES_NOT_STARTED = "Some instances failed to be started (or timeout was reached).";
    @Parameter(property="waitForRunningInstances", defaultValue="false")
    private Boolean waitForRunningInstances;
    @Parameter(property="failWhenTimeoutReached", defaultValue="false")
    private Boolean failWhenTimeoutReached;
    @Parameter(property="bw.start.running.statuses.number", defaultValue="3")
    private int numberOfRunningStatuses;
    private MicroAgent microAgent;

    private void startEAR() throws MojoExecutionException, IOException, ConsoleInitializationException, MicroAgentException, JAXBException {
        this.checkAppManage();
        this.getLog().info((CharSequence)STARTING_INSTANCES);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-start");
        arguments.add("-app");
        arguments.add(this.deployedProjectName);
        arguments.add("-domain");
        arguments.add(this.domainName);
        arguments.add("-user");
        arguments.add(this.domainUsername);
        arguments.add("-pw");
        arguments.add(this.domainPassword);
        ArrayList<File> tras = new ArrayList<File>();
        tras.add(this.tibcoAppManageTRAPath);
        this.launchTIBCOBinary(this.tibcoAppManagePath, tras, arguments, this.directory, STARTING_INSTANCES_FAILED);
        if (this.waitForRunningInstances.booleanValue()) {
            if (!this.initHawk(false)) {
                return;
            }
            ArrayList<ImmutablePair<String, String>> instances = new ArrayList<ImmutablePair<String, String>>();
            ApplicationManagement application = new ApplicationManagement(this.deploymentDescriptorFinal);
            String applicationName = application.getName();
            List<String> servicesNames = application.getInstancesNames(true);
            for (String serviceName : servicesNames) {
                instances.add((ImmutablePair<String, String>)new ImmutablePair((Object)applicationName, (Object)serviceName));
            }
            if (this.doWaitForRunningInstances(instances)) {
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)ALL_INSTANCES_STARTED);
            } else {
                this.getLog().info((CharSequence)"");
                if (this.failWhenTimeoutReached.booleanValue()) {
                    throw new MojoExecutionException(SOME_INSTANCES_NOT_STARTED);
                }
                this.getLog().info((CharSequence)SOME_INSTANCES_NOT_STARTED);
            }
        }
    }

    private List<MethodSubscriber> monitorInstances(List<ImmutablePair<String, String>> instances) throws ConsoleInitializationException, MicroAgentException {
        ArrayList<MethodSubscriber> result = new ArrayList<MethodSubscriber>();
        this.microAgent = new MicroAgent(this.hawkDomain, this.hawkRvService, this.hawkRvNetwork, this.hawkRvDaemon, "COM.TIBCO.admin.TRA");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)SUBSCRIBING_TO_HAWK_METHODS);
        for (ImmutablePair<String, String> instance : instances) {
            MethodSubscriber ms = new MethodSubscriber(this.microAgent);
            ms.setMethodName("getComponentInstanceStatus");
            ms.setArguments((String)instance.left, (String)instance.right);
            ms.setInterval(this.hawkSubscribeInterval);
            ms.setNumberOfRetry(this.hawkSubscribeNumberOfRetry);
            ms.subscribe(new RunningInstanceSubscriptionHandler(this.getLog(), ms, this.numberOfRunningStatuses));
            result.add(ms);
        }
        return result;
    }

    private boolean doWaitForRunningInstances(List<ImmutablePair<String, String>> instances) throws ConsoleInitializationException, MicroAgentException {
        List<MethodSubscriber> result = this.monitorInstances(instances);
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)WAITING_FOR_INSTANCES);
        while (RunningInstanceSubscriptionHandler.numberOfSubscriptions > 0) {
            this.getLog().debug((CharSequence)RunningInstanceSubscriptionHandler.numberOfSubscriptions.toString());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.microAgent.shutdown();
        for (MethodSubscriber ms : result) {
            if (ms.getResult() != null && ms.getResult().equals("RUNNING")) continue;
            return false;
        }
        return true;
    }

    @Override
    public void execute() throws MojoExecutionException {
        if (super.skip()) {
            return;
        }
        try {
            this.startEAR();
        }
        catch (IOException e) {
            throw new MojoExecutionException(STARTING_INSTANCES_FAILED, (Exception)e);
        }
        catch (ConsoleInitializationException e) {
            throw new MojoExecutionException(STARTING_INSTANCES_FAILED, (Exception)((Object)e));
        }
        catch (MicroAgentException e) {
            throw new MojoExecutionException(STARTING_INSTANCES_FAILED, (Exception)((Object)e));
        }
        catch (JAXBException e) {
            throw new MojoExecutionException(STARTING_INSTANCES_FAILED, (Exception)((Object)e));
        }
        catch (SecurityException e) {
            throw new MojoExecutionException(STARTING_INSTANCES_FAILED, (Exception)e);
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException(STARTING_INSTANCES_FAILED, (Exception)e);
        }
    }

    private static class RunningInstanceSubscriptionHandler
    extends DefaultSubscriptionHandler {
        private Log logger;
        private MethodSubscriber methodSubscriber;
        private Map<Integer, StatusHistory> statusesHistory;
        private int numberOfRunningStatuses;

        public RunningInstanceSubscriptionHandler(Log log, MethodSubscriber methodSubscriber, int numberOfRunningStatuses) {
            this.logger = log;
            this.methodSubscriber = methodSubscriber;
            this.statusesHistory = new LinkedHashMap<Integer, StatusHistory>();
            if (numberOfRunningStatuses <= 0) {
                numberOfRunningStatuses = 1;
            }
            this.numberOfRunningStatuses = numberOfRunningStatuses;
        }

        protected Log getLog() {
            return this.logger;
        }

        @Override
        public Object getResult() {
            return this.result;
        }

        @Override
        public void onSubscribe() {
            String instance = this.methodSubscriber.getArguments().get(0).getValue() + "-" + this.methodSubscriber.getArguments().get(1).getValue();
            Integer timeout = this.methodSubscriber.getInterval() * this.methodSubscriber.getNumberOfRetry() / 1000;
            this.getLog().info((CharSequence)("Subscription to the Hawk method started for instance '" + instance + "' (timeout is set to " + timeout + (timeout > 1 ? " seconds" : " second") + ")."));
        }

        @Override
        public void onData(Subscription s, MicroAgentData mad) {
            super.onData(s, mad);
            String data = this.formatData(mad.getData());
            this.getLog().debug((CharSequence)data);
            if (data != null && data.contains("STOPPED")) {
                this.statusesHistory.put(this.statusesHistory.size(), StatusHistory.STOPPED);
            } else if (data != null && data.contains("INITIALIZING")) {
                this.statusesHistory.put(this.statusesHistory.size(), StatusHistory.INITIALIZING);
            } else if (data != null && data.contains("RUNNING")) {
                this.statusesHistory.put(this.statusesHistory.size(), StatusHistory.RUNNING);
            }
            this.getLog().debug((CharSequence)this.statusesHistory.toString());
            if (this.failedToStart()) {
                s.cancel();
                this.result = "STOPPED";
                this.decreaseReferenceCount();
            } else if (this.isStarted()) {
                s.cancel();
                this.result = "RUNNING";
                this.decreaseReferenceCount();
                this.getLog().debug((CharSequence)"A subscription was canceled");
                this.getLog().debug((CharSequence)numberOfSubscriptions.toString());
                this.getLog().debug((CharSequence)numberOfSubscriptions.toString());
            }
        }

        private Integer getLastKeyForValue(Map<Integer, StatusHistory> map, StatusHistory value) {
            Integer result = -1;
            for (Integer key : map.keySet()) {
                if (!value.equals((Object)map.get(key))) continue;
                result = key;
            }
            return result;
        }

        private boolean failedToStart() {
            if (this.statusesHistory.containsValue((Object)StatusHistory.RUNNING) && this.statusesHistory.containsValue((Object)StatusHistory.STOPPED)) {
                Integer stoppedIndex = this.getLastKeyForValue(this.statusesHistory, StatusHistory.STOPPED);
                this.getLog().debug((CharSequence)stoppedIndex.toString());
                Integer runningIndex = this.getLastKeyForValue(this.statusesHistory, StatusHistory.RUNNING);
                this.getLog().debug((CharSequence)runningIndex.toString());
                return stoppedIndex > runningIndex;
            }
            return false;
        }

        private boolean isStarted() {
            return Collections.frequency(this.statusesHistory.values(), (Object)StatusHistory.RUNNING) > this.numberOfRunningStatuses;
        }

        @Override
        public void decreaseReferenceCount() {
            super.decreaseReferenceCount();
            this.getLog().debug((CharSequence)numberOfSubscriptions.toString());
        }

        @Override
        public void increaseReferenceCount() {
            super.increaseReferenceCount();
            this.getLog().debug((CharSequence)numberOfSubscriptions.toString());
        }

        @Override
        public void onError(Subscription s, MicroAgentException e) {
            this.getLog().debug((CharSequence)"A subscription caused an error");
        }

        @Override
        public void onErrorCleared(Subscription s) {
            this.getLog().debug((CharSequence)"A subscription cleared an error");
        }

        @Override
        public void onTermination(Subscription s, MicroAgentException e) {
            this.getLog().debug((CharSequence)"A subscription terminated");
        }

        private static enum StatusHistory {
            STOPPED,
            INITIALIZING,
            RUNNING;

        }
    }
}

