/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.doc;

import fr.fastconnect.factory.tibco.bw.maven.AbstractBWMojo;
import fr.fastconnect.factory.tibco.bw.maven.source.AbstractProjectsListMojo;
import fr.fastconnect.factory.tibco.bw.maven.source.ProcessModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractDocMojo
extends AbstractBWMojo {
    @Parameter(property="project.doc.directory", required=true, defaultValue="target/doc")
    protected File docDirectory;
    private List<File> files;

    public abstract void processFile(File var1) throws MojoExecutionException;

    protected String getDescription(File f) throws JAXBException {
        ProcessModel pm = new ProcessModel(f);
        String description = pm.getProcess().getDescription();
        return description;
    }

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        if (!this.docDirectory.exists()) {
            this.docDirectory.mkdirs();
        }
        this.getLog().info((CharSequence)("Generating project documentation in '" + this.docDirectory + '\"'));
        try {
            this.files = this.initFiles();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        for (File f : this.getFiles()) {
            this.processFile(f);
        }
    }

    public List<File> getFiles() {
        return this.files;
    }

    protected File getDirectoryToProcess() {
        return this.buildSrcDirectory;
    }

    protected List<File> initFiles() throws IOException {
        this.getLog().debug((CharSequence)"Looking for files to process...");
        FileSet restriction = new FileSet();
        File directory = this.getDirectoryToProcess();
        if (directory == null) {
            directory = new File(".");
        }
        restriction.setDirectory(directory.getAbsolutePath());
        restriction.addInclude("**/*.process");
        return AbstractProjectsListMojo.toFileList(restriction);
    }

    public void applyXSL(File in, File out, InputStream inputStream) throws MojoExecutionException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Templates template = factory.newTemplates(new StreamSource(inputStream));
            Transformer xformer = template.newTransformer();
            StreamSource source = new StreamSource(new FileInputStream(in));
            StreamResult result = new StreamResult(new FileOutputStream(out));
            xformer.transform(source, result);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

