/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.doc;

import fr.fastconnect.factory.tibco.bw.maven.doc.AbstractDocMojo;
import fr.fastconnect.factory.tibco.bw.maven.source.AbstractProjectsListMojo;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="generate-doc-apt", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
@Execute(goal="generate-doc-apt", phase=LifecyclePhase.PROCESS_SOURCES)
public class GenerateAPTDocMojo
extends AbstractDocMojo {
    private File aptDirectory;

    @Override
    public void processFile(File f) throws MojoExecutionException {
        String name = AbstractProjectsListMojo.getRelativePath(f.getAbsolutePath(), this.getDirectoryToProcess().getAbsolutePath(), File.separator);
        File out = new File(this.aptDirectory + File.separator + name + ".apt");
        out.getParentFile().mkdirs();
        this.getLog().debug((CharSequence)("Processing '" + f.getAbsolutePath() + "' to '" + out.getAbsolutePath()));
        this.applyXSL(f, out, GenerateAPTDocMojo.class.getResourceAsStream("/doc/bw-to-apt.xsl"));
    }

    @Override
    public void execute() throws MojoExecutionException {
        this.initAPTDirectory();
        super.execute();
    }

    private void initAPTDirectory() {
        this.aptDirectory = new File(this.docDirectory + File.separator + "apt");
        this.getLog().debug((CharSequence)this.aptDirectory.getAbsolutePath());
        if (!this.aptDirectory.exists()) {
            this.aptDirectory.mkdirs();
        }
    }

    @Override
    protected File getDirectoryToProcess() {
        return new File(this.docDirectory + File.separator + "xml");
    }

    @Override
    protected List<File> initFiles() throws IOException {
        this.getLog().debug((CharSequence)"Looking for files to process...");
        FileSet restriction = new FileSet();
        restriction.setDirectory(this.getDirectoryToProcess().getAbsolutePath());
        restriction.addInclude("**/*.xml");
        return AbstractProjectsListMojo.toFileList(restriction);
    }
}

