/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.doc;

import com.tibco.xmlns.bw.process._2003.Activity;
import com.tibco.xmlns.bw.process._2003.ProcessDefinition;
import fr.fastconnect.factory.tibco.bw.maven.doc.AbstractDocMojo;
import fr.fastconnect.factory.tibco.bw.maven.doc.jaxb.Bwdoc;
import fr.fastconnect.factory.tibco.bw.maven.doc.jaxb.Label;
import fr.fastconnect.factory.tibco.bw.maven.doc.jaxb.ObjectFactory;
import fr.fastconnect.factory.tibco.bw.maven.doc.jaxb.Process;
import fr.fastconnect.factory.tibco.bw.maven.source.AbstractProjectsListMojo;
import fr.fastconnect.factory.tibco.bw.maven.source.ProcessModel;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Mojo(name="generate-doc-xml", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
@Execute(goal="generate-doc-xml", phase=LifecyclePhase.PROCESS_SOURCES)
public class GenerateXMLDocMojo
extends AbstractDocMojo {
    private File xmlDirectory;

    private ProcessDefinition getProcessModel(File f) throws MojoExecutionException {
        ProcessDefinition result = null;
        try {
            ProcessModel pm = new ProcessModel(f);
            result = pm.getProcess();
        }
        catch (JAXBException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        return result;
    }

    @Override
    public void processFile(File f) throws MojoExecutionException {
        ProcessDefinition pd = this.getProcessModel(f);
        if (pd == null) {
            return;
        }
        String name = AbstractProjectsListMojo.getRelativePath(f.getAbsolutePath(), this.getDirectoryToProcess().getAbsolutePath(), File.separator);
        File out = new File(this.xmlDirectory + File.separator + name + ".xml");
        out.getParentFile().mkdirs();
        this.getLog().debug((CharSequence)("Processing '" + f.getAbsolutePath() + "' to '" + out.getAbsolutePath()));
        Bwdoc doc = new Bwdoc();
        doc.setDescription(pd.getDescription());
        if (doc.getLabels() == null) {
            doc.setLabels(new Bwdoc.Labels());
        }
        for (com.tibco.xmlns.bw.process._2003.Label l : pd.getLabel()) {
            Label label = new Label();
            label.setName(l.getName());
            label.setDescription(l.getDescription());
            doc.getLabels().getLabel().add(label);
        }
        if (doc.getCalledProcesses() == null) {
            doc.setCalledProcesses(new Bwdoc.CalledProcesses());
        }
        for (Activity a : pd.getActivity()) {
            Node node;
            if (!a.getType().equals("com.tibco.pe.core.CallProcessActivity")) continue;
            String pathValue = "";
            Element configElement = (Element)a.getConfig();
            NodeList nodes = configElement.getElementsByTagName("processName");
            if (nodes.getLength() > 0 && (node = nodes.item(0).getFirstChild()) != null) {
                pathValue = node.getNodeValue();
            }
            Process p = new Process();
            p.setName(a.getName());
            p.setPath(pathValue);
            doc.getCalledProcesses().getCalledProcess().add(p);
        }
        try {
            this.save(doc, out);
        }
        catch (JAXBException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    public void execute() throws MojoExecutionException {
        this.initXMLDirectory();
        super.execute();
    }

    private void initXMLDirectory() {
        this.xmlDirectory = new File(this.docDirectory + File.separator + "xml");
        this.getLog().debug((CharSequence)this.xmlDirectory.getAbsolutePath());
        if (!this.xmlDirectory.exists()) {
            this.xmlDirectory.mkdirs();
        }
    }

    private void save(Bwdoc doc, File f) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Marshaller m = jaxbContext.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)doc, f);
    }
}

