/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.hawk;

import COM.TIBCO.hawk.talon.CompositeData;
import COM.TIBCO.hawk.talon.DataElement;
import COM.TIBCO.hawk.talon.MicroAgentException;
import COM.TIBCO.hawk.talon.TabularData;

public class HawkFormatter {
    public static String formatData(Object madata) {
        if (madata instanceof CompositeData) {
            CompositeData compData = (CompositeData)madata;
            DataElement[] data = compData.getDataElements();
            StringBuffer sb = new StringBuffer("composite{");
            for (int i = 0; i < data.length; ++i) {
                sb.append(data[i] + (i == data.length - 1 ? "}" : ", "));
            }
            return sb.toString();
        }
        if (madata instanceof TabularData) {
            int i;
            TabularData tabData = (TabularData)madata;
            String[] columnNames = tabData.getColumnNames();
            String[] indexNames = tabData.getIndexNames();
            Object[][] table = tabData.getAllData();
            StringBuffer sb = new StringBuffer();
            sb.append("table{");
            sb.append("columns={");
            for (i = 0; i < columnNames.length; ++i) {
                sb.append(columnNames[i] + (i == columnNames.length - 1 ? "} " : ", "));
            }
            sb.append("indexColumns={");
            for (i = 0; i < indexNames.length; ++i) {
                sb.append(indexNames[i] + (i == indexNames.length - 1 ? "} " : ", "));
            }
            sb.append("values={");
            if (table == null) {
                sb.append("null");
            } else {
                for (i = 0; i < table.length; ++i) {
                    sb.append("row" + i + "={");
                    for (int j = 0; j < table[i].length; ++j) {
                        sb.append(table[i][j] + (j == table[i].length - 1 ? "} " : ", "));
                    }
                }
            }
            sb.append("}");
            sb.append("}");
            return sb.toString();
        }
        if (madata instanceof MicroAgentException) {
            MicroAgentException exc = (MicroAgentException)((Object)madata);
            return "EXCEPTION: " + (Object)((Object)exc);
        }
        if (madata == null) {
            return "Method Invocation returned no data.";
        }
        return "Method Invocation returned data of unknown type.";
    }
}

