/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.hawk;

import COM.TIBCO.hawk.console.hawkeye.ConsoleInitializationException;
import COM.TIBCO.hawk.talon.DataElement;
import COM.TIBCO.hawk.talon.MethodSubscription;
import COM.TIBCO.hawk.talon.MicroAgentData;
import COM.TIBCO.hawk.talon.MicroAgentException;
import COM.TIBCO.hawk.talon.Subscription;
import fr.fastconnect.factory.tibco.bw.maven.hawk.AbstractMethodAction;
import fr.fastconnect.factory.tibco.bw.maven.hawk.AdvancedSubscriptionHandler;
import fr.fastconnect.factory.tibco.bw.maven.hawk.DefaultSubscriptionHandler;
import fr.fastconnect.factory.tibco.bw.maven.hawk.HawkFormatter;
import fr.fastconnect.factory.tibco.bw.maven.hawk.MicroAgent;
import java.util.List;

public class MethodSubscriber
extends AbstractMethodAction {
    private MethodSubscription methodSubscription;
    private Integer interval = 15000;
    private Integer numberOfRetry = 4;
    private boolean displayOutputData = true;
    private AdvancedSubscriptionHandler subscriptionHandler;

    public AdvancedSubscriptionHandler getSubscriptionHandler() {
        return this.subscriptionHandler;
    }

    public MethodSubscriber(MicroAgent microAgent) {
        super(microAgent);
    }

    public MethodSubscriber(String hawkDomain, String rvService, String rvNetwork, String rvDaemon) throws ConsoleInitializationException {
        super(hawkDomain, rvService, rvNetwork, rvDaemon);
    }

    public MethodSubscriber(String hawkDomain, String rvService, String rvNetwork, String rvDaemon, String microAgentName) throws ConsoleInitializationException, MicroAgentException {
        super(hawkDomain, rvService, rvNetwork, rvDaemon, microAgentName);
    }

    @Override
    public void setMethodName(String methodName) {
        super.setMethodName(methodName);
        this.methodSubscription = new MethodSubscription(methodName, null, (long)this.getInterval().intValue());
    }

    @Override
    public void setMethodName(String methodName, List<DataElement> arguments) {
        super.setMethodName(methodName);
        this.methodSubscription = new MethodSubscription(methodName, arguments.toArray(new DataElement[0]), (long)this.getInterval().intValue());
    }

    public void setInterval(int interval) {
        this.interval = interval * 1000;
        this.setMethodName(this.getMethodName(), this.getArguments());
    }

    public void setNumberOfRetry(int numberOfRetry) {
        this.numberOfRetry = numberOfRetry;
    }

    public void subscribe(AdvancedSubscriptionHandler subscriptionHandler) throws MicroAgentException {
        this.subscriptionHandler = subscriptionHandler;
        subscriptionHandler.subscribe(this.getAgentManager(), this.getMicroAgentID(), this.methodSubscription, this.getNumberOfRetry(), this.displayOutputData);
    }

    public void subscribe() throws MicroAgentException {
        this.subscribe(new DefaultSubscriptionHandler());
    }

    public Object getResult() {
        if (this.subscriptionHandler == null) {
            return null;
        }
        return this.subscriptionHandler.getResult();
    }

    public Integer getInterval() {
        return this.interval;
    }

    public Integer getNumberOfRetry() {
        return this.numberOfRetry;
    }

    protected class RunningInstanceSubscriptionHandler
    extends DefaultSubscriptionHandler {
        protected RunningInstanceSubscriptionHandler() {
        }

        @Override
        public void onData(Subscription s, MicroAgentData mad) {
            super.onData(s, mad);
            String data = HawkFormatter.formatData(mad.getData());
            if (data != null && data.contains("RUNNING")) {
                s.cancel();
                this.result = "RUNNING";
                Integer n = numberOfSubscriptions;
                Integer n2 = numberOfSubscriptions = Integer.valueOf(numberOfSubscriptions - 1);
            }
        }
    }
}

