/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.hawk;

import COM.TIBCO.hawk.console.hawkeye.AgentManager;
import COM.TIBCO.hawk.console.hawkeye.ConsoleInitializationException;
import COM.TIBCO.hawk.talon.MicroAgentDescriptor;
import COM.TIBCO.hawk.talon.MicroAgentException;
import COM.TIBCO.hawk.talon.MicroAgentID;
import fr.fastconnect.factory.tibco.bw.maven.hawk.Hawk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MicroAgent {
    private Hawk hawk;
    private List<MicroAgentID> microAgentIDs;
    private String microAgentName;

    public MicroAgent(Hawk hawk) {
        this.hawk = hawk;
        this.microAgentIDs = new ArrayList<MicroAgentID>();
        this.microAgentName = null;
    }

    public MicroAgent(String hawkDomain, String rvService, String rvNetwork, String rvDaemon) throws ConsoleInitializationException {
        this(new Hawk(hawkDomain, rvService, rvNetwork, rvDaemon));
    }

    public MicroAgent(String hawkDomain, String rvService, String rvNetwork, String rvDaemon, String microAgentName) throws ConsoleInitializationException, MicroAgentException {
        this(new Hawk(hawkDomain, rvService, rvNetwork, rvDaemon));
        this.setMicroAgentName(microAgentName);
    }

    public void setMicroAgentName(String microAgentName) throws MicroAgentException {
        this.microAgentName = microAgentName;
        this.initMicroAgent();
    }

    private void initMicroAgent() throws MicroAgentException {
        this.microAgentIDs = Arrays.asList(this.hawk.getAgentManager().getMicroAgentIDs(this.microAgentName, 1));
        if (this.microAgentIDs.isEmpty()) {
            throw new MicroAgentException("No Hawk Micro Agent found for this name: '" + this.microAgentName + "'");
        }
    }

    private List<MicroAgentID> getMicroAgentIDs() {
        return this.microAgentIDs;
    }

    public MicroAgentID getMicroAgentID() {
        return this.getMicroAgentIDs().get(0);
    }

    public AgentManager getAgentManager() {
        return this.hawk.getAgentManager();
    }

    public void showDescription() throws MicroAgentException {
        MicroAgentDescriptor mad = null;
        mad = this.getAgentManager().describe(this.getMicroAgentID());
        System.out.println(mad.toFormattedString());
    }

    public void shutdown() {
        this.getAgentManager().shutdown();
    }
}

