/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.packaging;

import fr.fastconnect.factory.tibco.bw.maven.AbstractBWArtifactMojo;
import fr.fastconnect.factory.tibco.bw.maven.packaging.Events;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;

public abstract class AbstractPackagingMojo
extends AbstractBWArtifactMojo {
    protected static final String deployedProjectNameProperty = "deploy.project.name";
    protected static final String domainNameProperty = "tibco.domain.name";
    protected static final String domainUsernameProperty = "tibco.domain.username";
    protected static final String domainPasswordProperty = "tibco.domain.password";
    protected static final String deploymentDescriptorProperty = "deploy.descriptor";
    protected static final String deploymentDescriptorFinalProperty = "deploy.descriptor.final";
    protected static final String deploymentGlobalVariablesProperty = "deploy.properties.globalVariables";
    protected static final String deploymentServicesProperty = "deploy.properties.services";
    protected static final String deploymentGlobalVariablesReferenceProperty = "deploy.properties.globalVariables.reference";
    protected static final String deploymentServicesReferenceProperty = "deploy.properties.services.reference";
    protected static final String deploymentGlobalVariablesCommonProperty = "deploy.properties.globalVariables.common";
    protected static final String deploymentServicesCommonProperty = "deploy.properties.services.common";
    @Parameter(property="deploy.descriptor", defaultValue="${project.package.directory}/${project.build.finalName}.xml")
    protected File deploymentDescriptor;
    @Parameter(property="deploy.descriptor.final", defaultValue="${project.package.directory}/${project.build.finalName}-final.xml")
    protected File deploymentDescriptorFinal;
    @Parameter(property="deploy.properties.globalVariables", defaultValue="${project.package.directory}/${project.build.finalName}.gv.properties")
    protected File deploymentGlobalVariables;
    @Parameter(property="deploy.properties.services", defaultValue="${project.package.directory}/${project.build.finalName}.services.properties")
    protected File deploymentServices;
    @Parameter(property="deploy.properties.globalVariables.reference", defaultValue="${project.package.directory}/${project.artifactId}.gv.properties")
    protected File deploymentGlobalVariablesReference;
    @Parameter(property="deploy.properties.services.reference", defaultValue="${project.package.directory}/${project.artifactId}.services.properties")
    protected File deploymentServicesReference;
    @Parameter(property="deploy.properties.globalVariables.common", defaultValue="${project.package.directory}/${project.artifactId}.gv.properties")
    protected File deploymentGlobalVariablesCommon;
    @Parameter(property="deploy.properties.services.common", defaultValue="${project.package.directory}/${project.artifactId}.services.properties")
    protected File deploymentServicesCommon;
    @Parameter(property="ignoreReferenceFiles", defaultValue="false")
    protected boolean ignoreReferenceFiles;
    @Parameter(property="ignoreCommonFiles", defaultValue="false")
    protected boolean ignoreCommonFiles;
    @Parameter(property="filterProperties", defaultValue="false")
    protected boolean filterProperties;
    @Parameter(property="repoSelectInstance", defaultValue="local")
    protected String repoSelectInstance;
    @Parameter(property="repoHttpTimeout", defaultValue="600")
    protected Integer repoHttpTimeout;
    @Parameter(property="repoHttpUrl", defaultValue="")
    protected String repoHttpUrl;
    @Parameter(property="repoHttpServer", defaultValue="")
    protected String repoHttpServer;
    @Parameter(property="repoHttpUser", defaultValue="")
    protected String repoHttpUser;
    @Parameter(property="repoHttpPassword", defaultValue="")
    protected String repoHttpPassword;
    @Parameter(property="repoHttpExtraPropertyFile", defaultValue="")
    protected String repoHttpExtraPropertyFile;
    @Parameter(property="repoRvTimeout", defaultValue="600")
    protected Integer repoRvTimeout;
    @Parameter(property="repoRvDiscoveryTimeout", defaultValue="10")
    protected Integer repoRvDiscoveryTimeout;
    @Parameter(property="repoRvDaemon", defaultValue="tcp:7500")
    protected String repoRvDaemon;
    @Parameter(property="repoRvService", defaultValue="7500")
    protected String repoRvService;
    @Parameter(property="repoRvNetwork", defaultValue="")
    protected String repoRvNetwork;
    @Parameter(property="repoRvRegionalSubject", defaultValue="")
    protected String repoRvRegionalSubject;
    @Parameter(property="repoRvOperationRetry", defaultValue="0")
    protected Integer repoRvOperationRetry;
    @Parameter(property="repoRvServer", defaultValue="")
    protected String repoRvServer;
    @Parameter(property="repoRvUser", defaultValue="")
    protected String repoRvUser;
    @Parameter(property="repoRvPassword", defaultValue="")
    protected String repoRvPassword;
    @Parameter(property="repoRvExtraPropertyFile", defaultValue="")
    protected String repoRvExtraPropertyFile;
    @Parameter(property="repoLocalEncoding", defaultValue="UTF-8")
    protected String repoLocalEncoding;
    @Parameter(property="events", alias="events")
    protected Events events;
    @Parameter(property="deploy.maxDeploymentRevision", defaultValue="-1")
    protected String maxDeploymentRevision;
    @Parameter(property="deploy.contact", defaultValue="")
    protected String contact;
    @Parameter(property="deploy.description", defaultValue="")
    protected String description;
    @Component(role=MavenResourcesFiltering.class, hint="default")
    protected MavenResourcesFiltering mavenResourcesFiltering;

    protected Properties loadPropertiesFile(File propertiesFile) throws ConfigurationException, IOException {
        Properties properties = new Properties(){
            private static final long serialVersionUID = 7793482336210629858L;

            @Override
            public synchronized Enumeration<Object> keys() {
                return Collections.enumeration(new TreeSet<Object>(super.keySet()));
            }
        };
        FileInputStream fileInputStream = new FileInputStream(propertiesFile);
        properties.load(fileInputStream);
        return properties;
    }

    protected void savePropertiesToFile(File outputFile, Properties properties, String propertiesComment, String success, String failure) throws MojoExecutionException {
        OutputStream outputStream = null;
        try {
            outputFile.getParentFile().mkdirs();
            outputStream = new FileOutputStream(outputFile);
            properties.store(outputStream, propertiesComment);
            if (this.filterProperties) {
                this.getLog().debug((CharSequence)"Filtering properties files");
                File tmpDir = new File(outputFile.getParentFile(), "tmp");
                tmpDir.mkdir();
                ArrayList<Resource> resources = new ArrayList<Resource>();
                Resource r = new Resource();
                r.setDirectory(outputFile.getParentFile().getAbsolutePath());
                r.addInclude("*.properties");
                r.setFiltering(true);
                resources.add(r);
                ArrayList filters = new ArrayList();
                ArrayList nonFilteredFileExtensions = new ArrayList();
                MavenResourcesExecution mre = new MavenResourcesExecution(resources, tmpDir, this.getProject(), this.sourceEncoding, filters, nonFilteredFileExtensions, this.session);
                this.mavenResourcesFiltering.filterResources(mre);
                FileUtils.copyDirectory((File)tmpDir, (File)outputFile.getParentFile());
                FileUtils.deleteDirectory((File)tmpDir);
            }
            this.getLog().info((CharSequence)(success + " '" + outputFile + "'"));
        }
        catch (Exception e) {
            throw new MojoExecutionException(failure + " '" + outputFile + "'", e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    protected static String wildcardToRegex(String wildcard) {
        StringBuffer s = new StringBuffer(wildcard.length());
        s.append('^');
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block5;
                }
                case '?': {
                    s.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    public boolean skip() {
        if (this.skipPackage.booleanValue()) {
            this.getLog().info((CharSequence)"Skipping.");
        }
        return this.skipPackage;
    }
}

