/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.packaging;

import com.tibco.xmlns.applicationmanagement.ActionType;
import com.tibco.xmlns.applicationmanagement.Adapter;
import com.tibco.xmlns.applicationmanagement.ApplicationType;
import com.tibco.xmlns.applicationmanagement.Binding;
import com.tibco.xmlns.applicationmanagement.Bindings;
import com.tibco.xmlns.applicationmanagement.Bw;
import com.tibco.xmlns.applicationmanagement.Bwprocess;
import com.tibco.xmlns.applicationmanagement.Bwprocesses;
import com.tibco.xmlns.applicationmanagement.Checkpoints;
import com.tibco.xmlns.applicationmanagement.EventType;
import com.tibco.xmlns.applicationmanagement.Events;
import com.tibco.xmlns.applicationmanagement.FaultTolerant;
import com.tibco.xmlns.applicationmanagement.Monitor;
import com.tibco.xmlns.applicationmanagement.NVPairType;
import com.tibco.xmlns.applicationmanagement.NVPairs;
import com.tibco.xmlns.applicationmanagement.NameValuePair;
import com.tibco.xmlns.applicationmanagement.Product;
import com.tibco.xmlns.applicationmanagement.RepoInstances;
import com.tibco.xmlns.applicationmanagement.ServiceType;
import com.tibco.xmlns.applicationmanagement.Setting;
import com.tibco.xmlns.applicationmanagement.Shutdown;
import com.tibco.xmlns.dd.ObjectFactory;
import fr.fastconnect.factory.tibco.bw.maven.packaging.monitoring.AbstractEvent;
import fr.fastconnect.factory.tibco.bw.maven.packaging.monitoring.Actions;
import fr.fastconnect.factory.tibco.bw.maven.packaging.monitoring.AlertAction;
import fr.fastconnect.factory.tibco.bw.maven.packaging.monitoring.CustomAction;
import fr.fastconnect.factory.tibco.bw.maven.packaging.monitoring.EmailAction;
import fr.fastconnect.factory.tibco.bw.maven.packaging.monitoring.FailureEvent;
import fr.fastconnect.factory.tibco.bw.maven.packaging.monitoring.LogEvent;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.commons.io.FilenameUtils;

public class ApplicationManagement {
    private static final String APPLICATION_MANAGEMENT_NAMESPACE = "http://www.tibco.com/xmlns/ApplicationManagement";
    private ApplicationType application;
    private JAXBContext jaxbContext;
    private HashMap<String, Object> map = new HashMap();
    private Pattern patternElement = Pattern.compile("(\\w+)(\\[([\\w- \\*\\.\\/?]*)\\])?");
    private File xmlFile;

    public ApplicationManagement(File xmlFile) throws JAXBException {
        this.xmlFile = xmlFile;
        this.initApplication();
    }

    private void initApplication() throws JAXBException {
        this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{com.tibco.xmlns.applicationmanagement.ObjectFactory.class, com.tibco.xmlns.applicationmanagement.bw.ObjectFactory.class, ObjectFactory.class});
        Unmarshaller jaxbUnmarshaller = this.jaxbContext.createUnmarshaller();
        Object o = jaxbUnmarshaller.unmarshal(this.xmlFile);
        try {
            this.application = (ApplicationType)o;
        }
        catch (ClassCastException e) {
            JAXBElement j = (JAXBElement)o;
            this.application = (ApplicationType)j.getValue();
        }
    }

    public void save() throws JAXBException {
        Marshaller m = this.jaxbContext.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)this.application, this.xmlFile);
    }

    private NVPairs getGlobalVariablesPairs() {
        if (this.application.getNVPairs().getName().equals("Global Variables")) {
            return this.application.getNVPairs();
        }
        return null;
    }

    private List<Bw> getBWServices() {
        ArrayList<Bw> result = new ArrayList<Bw>();
        for (JAXBElement jaxbElement : this.application.getServices().getBaseService()) {
            if (!jaxbElement.getName().getLocalPart().equals("bw")) continue;
            result.add((Bw)jaxbElement.getValue());
        }
        return result;
    }

    private List<Adapter> getAdapterServices() {
        ArrayList<Adapter> result = new ArrayList<Adapter>();
        for (JAXBElement jaxbElement : this.application.getServices().getBaseService()) {
            if (!jaxbElement.getName().getLocalPart().equals("adapter")) continue;
            result.add((Adapter)jaxbElement.getValue());
        }
        return result;
    }

    public List<String> getInstancesNames(boolean onlyEnabledServices) {
        ArrayList<String> result = new ArrayList<String>();
        List<Bw> bwServices = this.getBWServices();
        for (Bw bw : bwServices) {
            Bindings bindings = bw.getBindings();
            boolean enabled = bw.isEnabled();
            if (!enabled && onlyEnabledServices) continue;
            for (Binding binding : bindings.getBinding()) {
                String name = binding.getName();
                if (name == null || name.isEmpty()) {
                    name = FilenameUtils.getBaseName((String)bw.getName());
                }
                result.add(name);
            }
        }
        return result;
    }

    private Bwprocesses getBWProcesses(Bw bwService) {
        for (Object o : bwService.getRest()) {
            if (!o.getClass().equals(Bwprocesses.class)) continue;
            return (Bwprocesses)o;
        }
        return null;
    }

    private Checkpoints getBWCheckpoints(Bw bwService) {
        for (Object o : bwService.getRest()) {
            if (!o.getClass().equals(Checkpoints.class)) continue;
            return (Checkpoints)o;
        }
        return null;
    }

    private FaultTolerant getBWFaultTolerant(Bw bwService) {
        for (Object o : bwService.getRest()) {
            if (!o.getClass().equals(FaultTolerant.class)) continue;
            return (FaultTolerant)o;
        }
        return null;
    }

    private Boolean isIsFt(Bw bw) {
        Boolean value = false;
        for (Object o : bw.getRest()) {
            if (!o.getClass().equals(JAXBElement.class)) continue;
            JAXBElement e = (JAXBElement)o;
            value = (Boolean)e.getValue();
        }
        return value;
    }

    private void setIsFt(Bw bw, Boolean value) {
        for (Object o : bw.getRest()) {
            if (!o.getClass().equals(JAXBElement.class)) continue;
            JAXBElement e = (JAXBElement)o;
            e.setValue((Object)value);
        }
    }

    public Properties getGlobalVariables() {
        SortedProperties result = new SortedProperties();
        NVPairs globalVariablesPairs = this.getGlobalVariablesPairs();
        if (globalVariablesPairs != null) {
            for (JAXBElement nvPair : globalVariablesPairs.getNVPair()) {
                String key = ((NVPairType)nvPair.getValue()).getName();
                String value = ((NVPairType)nvPair.getValue()).getValue();
                result.setProperty(key, value);
            }
        }
        return result;
    }

    public void setGlobalVariable(String key, String value) {
        if (key == null) {
            return;
        }
        NVPairs globalVariablesPairs = this.getGlobalVariablesPairs();
        if (globalVariablesPairs != null) {
            for (JAXBElement nvPair : globalVariablesPairs.getNVPair()) {
                if (!key.equals(((NVPairType)nvPair.getValue()).getName())) continue;
                ((NVPairType)nvPair.getValue()).setValue(value);
            }
        }
    }

    public Properties getServices() {
        SortedProperties result = new SortedProperties();
        result.putAll((Map<?, ?>)this.getProcessArchives());
        result.putAll((Map<?, ?>)this.getAdapterArchives());
        return result;
    }

    protected Properties getProcessArchives() {
        SortedProperties result = new SortedProperties();
        List<Bw> bwServices = this.getBWServices();
        for (Bw bwService : bwServices) {
            String serviceKey = "bw[" + bwService.getName() + "]";
            String key = serviceKey + "/enabled";
            result.setProperty(key, bwService.isEnabled());
            result.putAll((Map<?, ?>)this.getBindings(bwService));
            result.putAll((Map<?, ?>)this.getNVPairs(bwService));
            key = serviceKey + "/failureCount";
            result.setProperty(key, bwService.getFailureCount());
            key = serviceKey + "/failureInterval";
            result.setProperty(key, bwService.getFailureInterval());
            result.putAll((Map<?, ?>)this.getProcesses(bwService));
            result.putAll((Map<?, ?>)this.getCheckpoints(bwService));
            key = serviceKey + "/isFt";
            result.setProperty(key, this.isIsFt(bwService));
            result.putAll((Map<?, ?>)this.getFaultTolerant(bwService));
        }
        return result;
    }

    protected Properties getAdapterArchives() {
        SortedProperties result = new SortedProperties();
        List<Adapter> adapters = this.getAdapterServices();
        for (Adapter adapter : adapters) {
            String serviceKey = "adapter[" + adapter.getName() + "]";
            String key = serviceKey + "/enabled";
            result.setProperty(key, adapter.isEnabled());
            result.putAll((Map<?, ?>)this.getBindings(adapter));
            result.putAll((Map<?, ?>)this.getNVPairs(adapter));
            key = serviceKey + "/failureCount";
            result.setProperty(key, adapter.getFailureCount());
            key = serviceKey + "/failureInterval";
            result.setProperty(key, adapter.getFailureInterval());
        }
        return result;
    }

    private <T extends ServiceType> String getElementKey(T service) {
        String elementKey = service.getClass().getCanonicalName().contains("Adapter") ? "adapter" : "bw";
        return elementKey;
    }

    protected <T extends ServiceType> Properties getBindings(T service) {
        SortedProperties result = new SortedProperties();
        String serviceKey = this.getElementKey(service) + "[" + service.getName() + "]";
        Bindings bindings = service.getBindings();
        if (bindings != null) {
            for (Binding binding : bindings.getBinding()) {
                String processKey = serviceKey + "/bindings/binding[" + binding.getName() + "]";
                String key = processKey + "/machine";
                result.setProperty(key, binding.getMachine());
                if (binding.getProduct() != null) {
                    key = processKey + "/product/type";
                    result.setProperty(key, binding.getProduct().getType());
                    key = processKey + "/product/version";
                    result.setProperty(key, binding.getProduct().getVersion());
                    key = processKey + "/product/location";
                    result.setProperty(key, binding.getProduct().getLocation());
                }
                key = processKey + "/container";
                result.setProperty(key, binding.getContainer());
                key = processKey + "/description";
                result.setProperty(key, binding.getDescription());
                key = processKey + "/contact";
                result.setProperty(key, binding.getContact());
                Setting setting = binding.getSetting();
                if (setting != null) {
                    Setting.Java java;
                    key = processKey + "/setting/startOnBoot";
                    result.setProperty(key, setting.isStartOnBoot());
                    key = processKey + "/setting/enableVerbose";
                    result.setProperty(key, setting.isEnableVerbose());
                    key = processKey + "/setting/maxLogFileSize";
                    result.setProperty(key, setting.getMaxLogFileSize());
                    key = processKey + "/setting/maxLogFileCount";
                    result.setProperty(key, setting.getMaxLogFileCount());
                    key = processKey + "/setting/threadCount";
                    result.setProperty(key, setting.getThreadCount());
                    Setting.NTService ntService = setting.getNTService();
                    if (ntService != null) {
                        key = processKey + "/setting/NTService/runAsNT";
                        result.setProperty(key, ntService.isRunAsNT());
                        key = processKey + "/setting/NTService/startupType";
                        result.setProperty(key, ntService.getStartupType());
                        key = processKey + "/setting/NTService/loginAs";
                        result.setProperty(key, ntService.getLoginAs());
                        key = processKey + "/setting/NTService/password";
                        result.setProperty(key, ntService.getPassword());
                    }
                    if ((java = setting.getJava()) != null) {
                        key = processKey + "/setting/java/prepandClassPath";
                        result.setProperty(key, java.getPrepandClassPath());
                        key = processKey + "/setting/java/appendClassPath";
                        result.setProperty(key, java.getAppendClassPath());
                        key = processKey + "/setting/java/initHeapSize";
                        result.setProperty(key, java.getInitHeapSize());
                        key = processKey + "/setting/java/maxHeapSize";
                        result.setProperty(key, java.getMaxHeapSize());
                        key = processKey + "/setting/java/threadStackSize";
                        result.setProperty(key, java.getThreadStackSize());
                    }
                }
                key = processKey + "/ftWeight";
                result.setProperty(key, binding.getFtWeight());
                Shutdown shutdown = binding.getShutdown();
                if (shutdown != null) {
                    key = processKey + "/shutdown/checkpoint";
                    result.setProperty(key, shutdown.isCheckpoint());
                    key = processKey + "/shutdown/timeout";
                    result.setProperty(key, shutdown.getTimeout());
                }
                if (binding.getNVPairs() == null) continue;
                for (JAXBElement nvPair : binding.getNVPairs().getNVPair()) {
                    key = processKey + "/variables/variable[" + ((NVPairType)nvPair.getValue()).getName() + "]";
                    result.setProperty(key, ((NVPairType)nvPair.getValue()).getValue());
                }
            }
        }
        return result;
    }

    private <T extends ServiceType> Properties getNVPairs(T service) {
        SortedProperties result = new SortedProperties();
        String serviceKey = this.getElementKey(service) + "[" + service.getName() + "]";
        List nvPairsList = new ArrayList();
        nvPairsList = service.getNVPairs();
        for (NVPairs nvPairs : nvPairsList) {
            String variablesKey = serviceKey + "/variables[" + nvPairs.getName() + "]";
            for (JAXBElement nvPair : nvPairs.getNVPair()) {
                String key = variablesKey + "/variable[" + ((NVPairType)nvPair.getValue()).getName() + "]";
                result.setProperty(key, ((NVPairType)nvPair.getValue()).getValue());
            }
        }
        return result;
    }

    protected Properties getProcesses(Bw bwService) {
        SortedProperties result = new SortedProperties();
        String serviceKey = "bw[" + bwService.getName() + "]";
        Bwprocesses bwProcesses = this.getBWProcesses(bwService);
        if (bwProcesses != null) {
            for (Bwprocess process : bwProcesses.getBwprocess()) {
                String processKey = serviceKey + "/bwprocesses/bwprocess[" + process.getName() + "]";
                String key = processKey + "/starter";
                result.setProperty(key, process.getStarter());
                key = processKey + "/enabled";
                result.setProperty(key, process.isEnabled());
                key = processKey + "/maxJob";
                result.setProperty(key, process.getMaxJob());
                key = processKey + "/activation";
                result.setProperty(key, process.isActivation());
                key = processKey + "/flowLimit";
                result.setProperty(key, process.getFlowLimit());
            }
        }
        return result;
    }

    protected Properties getCheckpoints(Bw bwService) {
        SortedProperties result = new SortedProperties();
        String serviceKey = "bw[" + bwService.getName() + "]";
        Checkpoints checkpoints = this.getBWCheckpoints(bwService);
        if (checkpoints != null) {
            String key = serviceKey + "/checkpoints/tablePrefix";
            result.setProperty(key, checkpoints.getTablePrefix());
            for (String checkpoint : checkpoints.getCheckpoint()) {
                if (checkpoint == null) continue;
                key = serviceKey + "/checkpoints/checkpoint[" + checkpoint + "]";
                result.setProperty(key, checkpoint.equals(checkpoints.getSelected()));
            }
        }
        return result;
    }

    protected Properties getFaultTolerant(Bw bwService) {
        SortedProperties result = new SortedProperties();
        String serviceKey = "bw[" + bwService.getName() + "]";
        FaultTolerant faultTolerant = this.getBWFaultTolerant(bwService);
        if (faultTolerant != null) {
            String key = serviceKey + "/faultTolerant/hbInterval";
            result.setProperty(key, faultTolerant.getHbInterval());
            key = serviceKey + "/faultTolerant/activationInterval";
            result.setProperty(key, faultTolerant.getActivationInterval());
            key = serviceKey + "/faultTolerant/preparationDelay";
            result.setProperty(key, faultTolerant.getPreparationDelay());
        }
        return result;
    }

    private Bw getBw(String name) {
        List<Bw> services = this.getBWServices();
        if (services != null) {
            for (Bw service : services) {
                if (!service.getName().equals(name)) continue;
                return service;
            }
        }
        Bw result = new Bw();
        result.setName(name);
        services.add(result);
        QName qName = new QName(APPLICATION_MANAGEMENT_NAMESPACE, "bw");
        JAXBElement j = new JAXBElement(qName, Bw.class, (Object)result);
        this.application.getServices().getBaseService().add(j);
        return result;
    }

    private Adapter getAdapter(String name) {
        List<Adapter> services = this.getAdapterServices();
        if (services != null) {
            for (Adapter service : services) {
                if (!service.getName().equals(name)) continue;
                return service;
            }
        }
        Adapter result = new Adapter();
        result.setName(name);
        services.add(result);
        QName qName = new QName(APPLICATION_MANAGEMENT_NAMESPACE, "adapter");
        JAXBElement j = new JAXBElement(qName, Adapter.class, (Object)result);
        this.application.getServices().getBaseService().add(j);
        return result;
    }

    private <T extends ServiceType> Binding getBinding(String nameAttribute, T parent) {
        Bindings bindings = parent.getBindings();
        if (bindings != null) {
            for (Binding binding : bindings.getBinding()) {
                if (!binding.getName().equals(nameAttribute)) continue;
                return binding;
            }
        } else {
            bindings = new Bindings();
            parent.setBindings(bindings);
        }
        Binding binding = new Binding();
        binding.setName(nameAttribute);
        Product p = new Product();
        p.setType("bwengine");
        p.setLocation("");
        p.setVersion("");
        binding.setProduct(p);
        binding.setDescription("");
        binding.setContact("");
        Shutdown s = new Shutdown();
        s.setCheckpoint(Boolean.valueOf(false));
        s.setTimeout(new BigInteger("0"));
        binding.setShutdown(s);
        bindings.getBinding().add(binding);
        return binding;
    }

    private Object addBindingParameter(Binding binding, String key, String value) {
        if ("machine".equals(key)) {
            binding.setMachine(value);
        } else {
            if ("product".equals(key)) {
                if (binding.getProduct() == null) {
                    binding.setProduct(new Product());
                }
                return binding.getProduct();
            }
            if ("container".equals(key)) {
                binding.setContainer(value);
            } else if ("description".equals(key)) {
                binding.setDescription(value);
            } else if ("contact".equals(key)) {
                binding.setContact(value);
            } else {
                if ("setting".equals(key)) {
                    if (binding.getSetting() == null) {
                        binding.setSetting(new Setting());
                    }
                    return binding.getSetting();
                }
                if ("ftWeight".equals(key)) {
                    binding.setFtWeight(BigInteger.valueOf(Long.parseLong(value)));
                } else if ("shutdown".equals(key)) {
                    if (binding.getShutdown() == null) {
                        binding.setShutdown(new Shutdown());
                    }
                    return binding.getShutdown();
                }
            }
        }
        return binding;
    }

    private Object addProductParameter(Product product, String key, String value) {
        if ("type".equals(key)) {
            product.setType(value);
        } else if ("version".equals(key)) {
            product.setVersion(value);
        } else if ("location".equals(key)) {
            product.setLocation(value);
        }
        return product;
    }

    private Object addSettingParameter(Setting setting, String key, String value) {
        if ("startOnBoot".equals(key)) {
            setting.setStartOnBoot(Boolean.valueOf(Boolean.parseBoolean(value)));
        } else if ("enableVerbose".equals(key)) {
            setting.setEnableVerbose(Boolean.valueOf(Boolean.parseBoolean(value)));
        } else if ("maxLogFileSize".equals(key)) {
            setting.setMaxLogFileSize(BigInteger.valueOf(Long.parseLong(value)));
        } else if ("maxLogFileCount".equals(key)) {
            setting.setMaxLogFileCount(BigInteger.valueOf(Long.parseLong(value)));
        } else if ("threadCount".equals(key)) {
            setting.setThreadCount(BigInteger.valueOf(Long.parseLong(value)));
        } else {
            if ("NTService".equals(key)) {
                if (setting.getNTService() == null) {
                    setting.setNTService(new Setting.NTService());
                }
                return setting.getNTService();
            }
            if ("java".equals(key)) {
                if (setting.getJava() == null) {
                    setting.setJava(new Setting.Java());
                }
                return setting.getJava();
            }
        }
        return setting;
    }

    private Object addNTServiceParameter(Setting.NTService ntService, String key, String value) {
        if ("runAsNT".equals(key)) {
            ntService.setRunAsNT(Boolean.parseBoolean(value));
        } else if ("startupType".equals(key)) {
            ntService.setStartupType(value);
        } else if ("loginAs".equals(key)) {
            ntService.setLoginAs(value);
        } else if ("password".equals(key)) {
            ntService.setPassword(value);
        }
        return ntService;
    }

    private Object addJavaParameter(Setting.Java java, String key, String value) {
        if ("prepandClassPath".equals(key)) {
            java.setPrepandClassPath(value);
        } else if ("appendClassPath".equals(key)) {
            java.setAppendClassPath(value);
        } else if ("initHeapSize".equals(key)) {
            java.setInitHeapSize(BigInteger.valueOf(Long.parseLong(value)));
        } else if ("maxHeapSize".equals(key)) {
            java.setMaxHeapSize(BigInteger.valueOf(Long.parseLong(value)));
        } else if ("threadStackSize".equals(key)) {
            java.setThreadStackSize(BigInteger.valueOf(Long.parseLong(value)));
        }
        return java;
    }

    private Object addShutdownParameter(Shutdown shutdown, String key, String value) {
        if ("checkpoint".equals(key)) {
            shutdown.setCheckpoint(Boolean.valueOf(Boolean.parseBoolean(value)));
        } else if ("timeout".equals(key)) {
            shutdown.setTimeout(BigInteger.valueOf(Long.parseLong(value)));
        }
        return shutdown;
    }

    private Bwprocess getBWProcess(String nameAttribute, Bw parent) {
        Bwprocesses bwProcesses = this.getBWProcesses(parent);
        if (bwProcesses != null) {
            for (Bwprocess bwProcess : bwProcesses.getBwprocess()) {
                if (!bwProcess.getName().equals(nameAttribute)) continue;
                return bwProcess;
            }
        } else {
            bwProcesses = new Bwprocesses();
            parent.getRest().add(bwProcesses);
        }
        Bwprocess bwProcess = new Bwprocess();
        bwProcess.setName(nameAttribute);
        bwProcesses.getBwprocess().add(bwProcess);
        return bwProcess;
    }

    private void addBWProcessParameter(Bwprocess bwProcess, String key, String value) {
        if ("starter".equals(key)) {
            bwProcess.setStarter(value);
        } else if ("enabled".equals(key)) {
            bwProcess.setEnabled(Boolean.valueOf(Boolean.parseBoolean(value)));
        } else if ("maxJob".equals(key)) {
            bwProcess.setMaxJob(BigInteger.valueOf(Long.parseLong(value)));
        } else if ("activation".equals(key)) {
            bwProcess.setActivation(Boolean.valueOf(Boolean.parseBoolean(value)));
        } else if ("flowLimit".equals(key)) {
            bwProcess.setFlowLimit(BigInteger.valueOf(Long.parseLong(value)));
        }
    }

    private void addFaultTolerantParameter(FaultTolerant faultTolerant, String key, String value) {
        if ("activationInterval".equals(key)) {
            faultTolerant.setActivationInterval(BigInteger.valueOf(Long.parseLong(value)));
        } else if ("hbInterval".equals(key)) {
            faultTolerant.setHbInterval(BigInteger.valueOf(Long.parseLong(value)));
        } else if ("preparationDelay".equals(key)) {
            faultTolerant.setPreparationDelay(BigInteger.valueOf(Long.parseLong(value)));
        }
    }

    private void addCheckpointsParameter(Checkpoints parent, String key, String value) {
    }

    private Object addBwParameter(Bw bw, String key, String value) {
        if ("enabled".equals(key)) {
            bw.setEnabled(Boolean.valueOf(Boolean.parseBoolean(value)));
        } else if ("failureCount".equals(key)) {
            bw.setFailureCount(BigInteger.valueOf(Long.parseLong(value)));
        } else if ("failureInterval".equals(key)) {
            bw.setFailureInterval(BigInteger.valueOf(Long.parseLong(value)));
        } else if ("isFt".equals(key)) {
            this.setIsFt(bw, Boolean.parseBoolean(value));
        } else if ("faultTolerant".equals(key)) {
            return this.getBWFaultTolerant(bw);
        }
        return bw;
    }

    private Object addAdapterParameter(Adapter adapter, String key, String value) {
        if ("enabled".equals(key)) {
            adapter.setEnabled(Boolean.valueOf(Boolean.parseBoolean(value)));
        } else if ("failureCount".equals(key)) {
            adapter.setFailureCount(BigInteger.valueOf(Long.parseLong(value)));
        } else if ("failureInterval".equals(key)) {
            adapter.setFailureInterval(BigInteger.valueOf(Long.parseLong(value)));
        }
        return adapter;
    }

    public Object getElement(String path, String element, String value, Object parent) {
        if (this.map.containsKey(path)) {
            return this.map.get(path);
        }
        Matcher matcherElement = this.patternElement.matcher(element);
        if (matcherElement.matches()) {
            String elementName = matcherElement.group(1);
            String nameAttribute = matcherElement.group(3);
            if (nameAttribute != null) {
                if (elementName.equals("variables")) {
                    NVPairs gvs = null;
                    if (parent.getClass().equals(Bw.class) || parent.getClass().equals(Adapter.class)) {
                        ServiceType service = (ServiceType)parent;
                        for (NVPairs nvPairs : service.getNVPairs()) {
                            if (!nvPairs.getName().equals(nameAttribute)) continue;
                            gvs = nvPairs;
                            break;
                        }
                        if (gvs == null) {
                            gvs = new NVPairs();
                            service.getNVPairs().add(gvs);
                        }
                    } else if (parent.getClass().equals(Binding.class)) {
                        gvs = new NVPairs();
                        gvs.setName(nameAttribute);
                        ((Binding)parent).setNVPairs(gvs);
                    }
                    this.map.put(path, gvs);
                    return gvs;
                }
                if (elementName.equals("variable")) {
                    NameValuePair simpleGV = new NameValuePair();
                    simpleGV.setName(nameAttribute);
                    simpleGV.setValue(value);
                    QName name = new QName(APPLICATION_MANAGEMENT_NAMESPACE, "NameValuePair");
                    JAXBElement _simpleGV = new JAXBElement(name, NameValuePair.class, (Object)simpleGV);
                    boolean found = false;
                    for (JAXBElement nvPair : ((NVPairs)parent).getNVPair()) {
                        if (!nameAttribute.equals(((NVPairType)nvPair.getValue()).getName())) continue;
                        ((NVPairType)nvPair.getValue()).setValue(value);
                        found = true;
                    }
                    if (!found) {
                        ((NVPairs)parent).getNVPair().add(_simpleGV);
                    }
                    return simpleGV;
                }
                if (elementName.equals("bw")) {
                    Bw service = this.getBw(nameAttribute);
                    this.map.put(path, service);
                    return service;
                }
                if (elementName.equals("adapter")) {
                    Adapter service = this.getAdapter(nameAttribute);
                    this.map.put(path, service);
                    return service;
                }
                if (elementName.equals("binding")) {
                    Binding binding = null;
                    if (parent.getClass().equals(Bw.class)) {
                        binding = this.getBinding(nameAttribute, (Bw)parent);
                    } else if (parent.getClass().equals(Adapter.class)) {
                        binding = this.getBinding(nameAttribute, (Adapter)parent);
                    }
                    this.map.put(path, binding);
                    return binding;
                }
                if (elementName.equals("bwprocess")) {
                    Bwprocess bwProcess = this.getBWProcess(nameAttribute, (Bw)parent);
                    this.map.put(path, bwProcess);
                    return bwProcess;
                }
                if (elementName.equals("checkpoint")) {
                    Checkpoints checkpoints = (Checkpoints)parent;
                    if (!checkpoints.getCheckpoint().contains(nameAttribute)) {
                        checkpoints.getCheckpoint().add(nameAttribute);
                    }
                    if ("true".equals(value)) {
                        checkpoints.setSelected(nameAttribute);
                    }
                }
            } else {
                if (elementName.equals("variables")) {
                    NVPairs gvs = null;
                    if (parent.getClass().equals(Bw.class) || parent.getClass().equals(Adapter.class)) {
                        ServiceType service = (ServiceType)parent;
                        for (NVPairs nvPairs : service.getNVPairs()) {
                            if (!nvPairs.getName().equals("Runtime Variables")) continue;
                            gvs = nvPairs;
                            break;
                        }
                        if (gvs == null) {
                            gvs = new NVPairs();
                            service.getNVPairs().add(gvs);
                        }
                    } else if (parent.getClass().equals(Binding.class)) {
                        gvs = new NVPairs();
                        gvs.setName("Runtime Variables");
                        ((Binding)parent).setNVPairs(gvs);
                    }
                    this.map.put(path, gvs);
                    return gvs;
                }
                if (elementName.equals("checkpoints")) {
                    Checkpoints checkpoints = this.getBWCheckpoints((Bw)parent);
                    this.map.put(path, checkpoints);
                    return checkpoints;
                }
                if (elementName.equals("tablePrefix")) {
                    Checkpoints checkpoints = (Checkpoints)parent;
                    checkpoints.setTablePrefix(value);
                } else {
                    if (parent.getClass().equals(Binding.class)) {
                        return this.addBindingParameter((Binding)parent, elementName, value);
                    }
                    if (parent.getClass().equals(Product.class)) {
                        return this.addProductParameter((Product)parent, elementName, value);
                    }
                    if (parent.getClass().equals(Setting.class)) {
                        return this.addSettingParameter((Setting)parent, elementName, value);
                    }
                    if (parent.getClass().equals(Setting.NTService.class)) {
                        return this.addNTServiceParameter((Setting.NTService)parent, elementName, value);
                    }
                    if (parent.getClass().equals(Setting.Java.class)) {
                        return this.addJavaParameter((Setting.Java)parent, elementName, value);
                    }
                    if (parent.getClass().equals(Shutdown.class)) {
                        return this.addShutdownParameter((Shutdown)parent, elementName, value);
                    }
                    if (parent.getClass().equals(Bwprocess.class)) {
                        this.addBWProcessParameter((Bwprocess)parent, elementName, value);
                    } else if (parent.getClass().equals(FaultTolerant.class)) {
                        this.addFaultTolerantParameter((FaultTolerant)parent, elementName, value);
                    } else if (parent.getClass().equals(Checkpoints.class)) {
                        this.addCheckpointsParameter((Checkpoints)parent, elementName, value);
                    } else {
                        if (parent.getClass().equals(Bw.class)) {
                            return this.addBwParameter((Bw)parent, elementName, value);
                        }
                        if (parent.getClass().equals(Adapter.class)) {
                            return this.addAdapterParameter((Adapter)parent, elementName, value);
                        }
                    }
                }
            }
        }
        return parent;
    }

    public void removeDuplicateBinding() {
        List<Bw> bwServices = this.getBWServices();
        for (Bw bw : bwServices) {
            boolean first = true;
            List bindings = bw.getBindings().getBinding();
            Iterator iterator = bindings.iterator();
            while (iterator.hasNext()) {
                Binding binding = (Binding)iterator.next();
                if (!first && binding.getName().equals("")) {
                    iterator.remove();
                }
                first = false;
            }
        }
        List<Adapter> adapterServices = this.getAdapterServices();
        for (Adapter adapter : adapterServices) {
            boolean first = true;
            List bindings = adapter.getBindings().getBinding();
            Iterator iterator = bindings.iterator();
            while (iterator.hasNext()) {
                Binding binding = (Binding)iterator.next();
                if (!first && binding.getName().equals("")) {
                    iterator.remove();
                }
                first = false;
            }
        }
    }

    public void removeDefaultBindingIfNotExists(Properties properties) {
        List<Bw> bwServices = this.getBWServices();
        for (Bw bw : bwServices) {
            String path = "bw[" + bw.getName() + "]/bindings/binding[]/machine";
            List bindings = bw.getBindings().getBinding();
            Iterator iterator = bindings.iterator();
            while (iterator.hasNext()) {
                Binding binding = (Binding)iterator.next();
                if (!binding.getName().equals("") || properties.containsKey(path)) continue;
                iterator.remove();
            }
        }
        List<Adapter> adapterServices = this.getAdapterServices();
        for (Adapter adapter : adapterServices) {
            String path = "adapter[" + adapter.getName() + "]/bindings/binding[]/machine";
            List bindings = adapter.getBindings().getBinding();
            Iterator iterator = bindings.iterator();
            while (iterator.hasNext()) {
                Binding binding = (Binding)iterator.next();
                if (!binding.getName().equals("") || properties.containsKey(path)) continue;
                iterator.remove();
            }
        }
    }

    public String getName() {
        if (this.application == null) {
            return null;
        }
        return this.application.getName();
    }

    public String getDescription() {
        if (this.application == null) {
            return null;
        }
        return this.application.getDescription();
    }

    public String getContact() {
        if (this.application == null) {
            return null;
        }
        return this.application.getContact();
    }

    public String getMaxDeploymentRevision() {
        if (this.application == null) {
            return null;
        }
        return this.application.getMaxdeploymentrevision();
    }

    public void setName(String name) {
        if (this.application == null) {
            return;
        }
        this.application.setName(name);
    }

    public void setContact(String contact) {
        if (this.application == null) {
            return;
        }
        this.application.setContact(contact);
    }

    public void setDescription(String description) {
        if (this.application == null) {
            return;
        }
        this.application.setDescription(description);
    }

    public void setMaxDeploymentRevision(String maxDeploymentRevision) {
        if (this.application == null) {
            return;
        }
        this.application.setMaxdeploymentrevision(maxDeploymentRevision);
    }

    public RepoInstances getRepoInstances() {
        return this.application.getRepoInstances();
    }

    public Monitor getMonitor(String service) {
        Monitor result = null;
        Bw bw = this.getBw(service);
        if (bw != null) {
            result = bw.getMonitor();
        }
        return result;
    }

    public static <E extends AbstractEvent> void addEvent(Events events, E event) {
        com.tibco.xmlns.applicationmanagement.AlertAction action;
        com.tibco.xmlns.applicationmanagement.FailureEvent e;
        if (events == null || event == null) {
            return;
        }
        String eventType = event.getClass().getName();
        if (FailureEvent.class.getName().equals(eventType)) {
            e = new com.tibco.xmlns.applicationmanagement.FailureEvent();
            e.setFailure(((FailureEvent)event).getFailure());
        } else if (LogEvent.class.getName().equals(eventType)) {
            e = new com.tibco.xmlns.applicationmanagement.LogEvent();
            ((com.tibco.xmlns.applicationmanagement.LogEvent)e).setMatch(((LogEvent)event).getMatch());
        } else {
            throw new UnsupportedOperationException();
        }
        Actions _actions = event.getActions();
        com.tibco.xmlns.applicationmanagement.Actions actions = new com.tibco.xmlns.applicationmanagement.Actions();
        for (AlertAction alert : _actions.getAlerts()) {
            action = new com.tibco.xmlns.applicationmanagement.AlertAction();
            action.setEnabled(alert.getEnabled());
            action.setPerformPolicy(alert.getPerformPolicy());
            action.setLevel(alert.getLevel());
            action.setMessage(alert.getMessage());
            ApplicationManagement.addAction(actions, action);
        }
        for (CustomAction custom : _actions.getCustoms()) {
            action = new com.tibco.xmlns.applicationmanagement.CustomAction();
            action.setEnabled(custom.getEnabled());
            action.setPerformPolicy(custom.getPerformPolicy());
            action.setArguments(custom.getArguments());
            action.setCommand(custom.getCommand());
            ApplicationManagement.addAction(actions, action);
        }
        for (EmailAction email : _actions.getEmails()) {
            action = new com.tibco.xmlns.applicationmanagement.EmailAction();
            action.setEnabled(email.getEnabled());
            action.setPerformPolicy(email.getPerformPolicy());
            action.setCc(email.getCc());
            action.setMessage(email.getMessage());
            action.setSMTPServer(email.getSmtpServer());
            action.setSubject(email.getSubject());
            action.setTo(email.getTo());
            ApplicationManagement.addAction(actions, action);
        }
        e.setActions(actions);
        e.setDescription(event.getDescription());
        e.setRestart(Boolean.valueOf(event.getRestart()));
        ApplicationManagement.addEvent(events, e);
    }

    protected static <E extends EventType> void addEvent(Events events, E event) {
        if (events == null || event == null) {
            return;
        }
        Class<?> c = event.getClass();
        JAXBElement e = new JAXBElement(new QName("name"), c, event);
        events.getEvent().add(e);
    }

    public static <A extends ActionType> void addAction(com.tibco.xmlns.applicationmanagement.Actions actions, A action) {
        if (actions == null || action == null) {
            return;
        }
        Class<?> c = action.getClass();
        JAXBElement a = new JAXBElement(new QName("name"), c, action);
        actions.getAction().add(a);
    }

    public void addMonitoringEventsToAllServices(Events events) {
        List events_ = events.getEvent();
        if (events_ != null && !events_.isEmpty()) {
            for (Bw service : this.getBWServices()) {
                Monitor monitor = service.getMonitor();
                if (monitor == null) continue;
                monitor.setEvents(events);
            }
        }
    }

    public static class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 3733070302160913988L;

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(new TreeSet<Object>(super.keySet()));
        }

        @Override
        public synchronized Object setProperty(String key, String value) {
            if (value != null) {
                return super.setProperty(key, value);
            }
            return null;
        }

        public synchronized Object setProperty(String key, BigInteger value) {
            if (value != null) {
                return super.setProperty(key, value.toString());
            }
            return null;
        }

        public synchronized Object setProperty(String key, Boolean value) {
            if (value != null) {
                return super.setProperty(key, value.toString());
            }
            return null;
        }
    }
}

